<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use App\Models\PrintSetting;
use App\Models\ReceiptPrint;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use App\Models\Bill;
use App\Models\BillItem;
use App\Models\Product;
use App\Models\ExtraExpense;
use App\Models\CreditDetail;
use App\Models\SupplierLedger;
use App\Models\LedgerAdjustment;
use App\Models\LedgerItem;
use Carbon\Carbon;

class AdminController extends Controller
{
   public function welcome()
   {
      return view('welcome');
   }
   public function view()
{
    if (auth()->check() && auth()->user()->role === 'admin') {
        return view('dashboard');
    }
       
    return redirect()->route('login.index')->with('error', 'login First.');
}

   Public function loginShow()
   {
    return view('login');
   }
   Public function registerShow()
   {
    return view('register');
   }

   public function profile()
    {
        $user = Auth::user();
        return view('profile.index', compact('user'));
    }

    public function edit()
    {
        $user = Auth::user();
        return view('profile.update', compact('user'));
    }

    public function update(Request $request)
    {
        $user = Auth::user();

        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email,' . $user->id,
        ]);

        $user->update([
            'name' => $request->name,
            'email' => $request->email,
        ]);

        return redirect()->route('profile')->with('success', 'Profile updated successfully!');
    }
    public function preview()
    {
        $printSetting = PrintSetting::first();
        return view('printPreview', compact('printSetting'));
    }

    public function Printedit()
    {
        $printSetting = PrintSetting::first();
        return view('print.edit', compact('printSetting'));
    }

    public function Printupdate(Request $request)
    {
        $data = $request->validate([
            'title' => 'required|string|max:255',
            'address' => 'required|string|max:500',
            'phone' => 'required|string|max:20',
            'footer_note' => 'required|string|max:1000',
            'goodbye_message' => 'required|string|max:500',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048'
        ]);

        $printSetting = PrintSetting::firstOrNew();

        if ($request->hasFile('logo')) {
            $path = $request->file('logo')->store('print_logos', 'public');
            $data['logo_path'] = $path;
        }

        $printSetting->fill($data);
        $printSetting->save();

        return redirect()->route('print.preview')->with('success', 'Print settings updated successfully!');
    }
    public function receiptprint()
{

    $receiptPrint = ReceiptPrint::first(); 
    return view('receiptprint', compact('receiptPrint'));
}
public function receiptprintcreate(Request $request)
{
    //dd($request->all());
    $validated = $request->validate([
        'header' => 'required|string|max:255',
        'footer' => 'required|string|max:255',
        'image1' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
        'image2' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048'
    ]);

    $receiptPrint = new ReceiptPrint();
    $receiptPrint->header = $validated['header'];
    $receiptPrint->footer = $validated['footer'];

    if ($request->hasFile('image1')) {
        $path1 = $request->file('image1')->store('receipts', 'public');
        $receiptPrint->image1 = $path1;
    }

    if ($request->hasFile('image2')) {
        $path2 = $request->file('image2')->store('receipts', 'public');
        $receiptPrint->image2 = $path2;
    }

    $receiptPrint->save();

     return redirect()->back()->with('success', 'Receipt template create!');
}
public function receiptprintupdate(Request $request, $id)
{
    $receiptPrint = ReceiptPrint::findOrFail($id);

    // Validate and assign text/color/number inputs
    $receiptPrint->header = $request->input('header');
    $receiptPrint->footer = $request->input('footer');
    $receiptPrint->border1_color = $request->input('border1_color');
    $receiptPrint->border1_width = $request->input('border1_width');
    $receiptPrint->border2_color = $request->input('border2_color');
    $receiptPrint->border2_width = $request->input('border2_width');
    $receiptPrint->footer_background_color = $request->input('footer_background_color');
    $receiptPrint->footer_text_color = $request->input('footer_text_color');
    
    // Add the new fields
    $receiptPrint->header_text_color = $request->input('header_text_color', '#000000');
    $receiptPrint->content_text_color = $request->input('content_text_color', '#000000');
    $receiptPrint->finding_color = $request->input('finding_color', '#000000');
    $receiptPrint->diagnosis_color = $request->input('diagnosis_color', '#000000');

    // Handle image uploads if present
    if ($request->hasFile('image1')) {
        $path1 = $request->file('image1')->store('receipts', 'public');
        $receiptPrint->image1 = $path1;
    }

    if ($request->hasFile('image2')) {
        $path2 = $request->file('image2')->store('receipts', 'public');
        $receiptPrint->image2 = $path2;
    }

    if ($request->hasFile('background_image')) {
        $backgroundPath = $request->file('background_image')->store('receipts', 'public');
        $receiptPrint->background_image = $backgroundPath;
    }

    $receiptPrint->save();

    return redirect()->back()->with('success', 'Receipt template updated!');
}

 public function summary()
{
    if (!Session::has('summary_accessed')) {
        Session::put('summary_accessed', true); 
        Auth::logout(); 
        return redirect('/loginForm')->with('message', 'Please log in again to access the summary.');
    }

    $today = Carbon::today();

    // Credit Sales (only bills with positive total_amount and not outside sales)
    $creditAmount = Bill::whereDate('created_at', $today)
        ->where('payment', 'credit')
        ->where('total_amount', '>', 0)
        ->where('sale', '!=', 'outside') // Exclude outside sales
        ->sum('total_amount');

    // Extra Expenses
    $extraExpenses = ExtraExpense::whereDate('created_at', $today)->get();
    $extraExpenseAmount = $extraExpenses->sum('amount');

    // Get bills with positive amounts (excluding fully returned bills and outside sales)
    $bills = Bill::whereDate('created_at', $today)
        ->where('total_amount', '>', 0)
        ->where('sale', '!=', 'outside') // Exclude outside sales
        ->get();
    
    $billIds = $bills->pluck('id');

    // Get bill items with positive quantities and amounts
    $billItems = BillItem::whereIn('bill_id', $billIds)
        ->where('qty', '>', 0)
        ->where('amount', '>', 0)
        ->get();

    // Total Sales (already filtered to exclude outside sales)
    $totalSalesAmount = $bills->sum('total_amount');
    $totalSalesQty = $billItems->sum('qty');
       
    // Calculate total cost of sales
    $totalCost = 0;
    foreach ($billItems as $item) {
        $product = Product::find($item->product_id);
        if ($product) {
            $totalCost += $product->purchase_price * $item->qty;
        }
    }

    // Profit = Sales - Cost
    $profit = $totalSalesAmount - $totalCost;

    $printSetting = PrintSetting::first();
    
    // Credit Details (if applicable)
    $creditDetails = CreditDetail::whereDate('created_at', $today)->get();
    
    // Supplier Payments
    $totalSupplierLedgerPayments = LedgerItem::whereDate('created_at', $today)
        ->sum('paid_amount');

    $totalLedgerAdjustmentPayments = LedgerAdjustment::whereDate('created_at', $today)
        ->sum('paid_amount');

    $totalSupplierPayments = $totalSupplierLedgerPayments + $totalLedgerAdjustmentPayments;

    return view('counterClose', compact(
        'totalSalesQty',
        'totalSalesAmount',
        'creditAmount',
        'extraExpenseAmount',
        'profit',
        'creditDetails',
        'bills',
        'extraExpenses',
        'printSetting',
        'totalSupplierPayments'
    ));
}
     public function resetSystem(Request $request)
{
    // Check if session has reset attempts counter
    $resetAttempts = session('reset_attempts', 0);
    
    // Increment attempt counter
    session(['reset_attempts' => $resetAttempts + 1]);
    
    // If less than 5 attempts, logout and redirect to login
    if ($resetAttempts < 5) {
        Auth::logout();
        return redirect()->route('login.index')->with('reset_warning', 
            "Reset attempt {$resetAttempts} of 5. Please login again to continue reset process.");
    }
    
    // On 6th attempt, perform the actual reset
    try {
        // Get all table names except users and migrations
        $tables = DB::select('SHOW TABLES');
        $tables = array_map('current', $tables);
        
        // Disable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        
        foreach ($tables as $table) {
            // Skip users and migrations tables
            if ($table === 'users' || $table === 'migrations') {
                continue;
            }
            
            // Truncate table
            DB::table($table)->truncate();
        }
        
        // Re-enable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
        
        // Clear reset attempts
        $request->session()->forget('reset_attempts');
        
        // Logout and redirect with success message
        Auth::logout();
        return redirect()->route('login.index')
            ->with('success', 'System reset successfully. All tables (except users) have been cleared.');
            
    } catch (\Exception $e) {
        // Clear reset attempts on error
        $request->session()->forget('reset_attempts');
        
        return redirect()->back()
            ->with('error', 'Reset failed: ' . $e->getMessage());
    }
}

}
