<?php

namespace App\Http\Controllers;
use App\Models\ExtraExpense;
use Illuminate\Http\Request;

class ExtraController extends Controller
{
    public function expenseForm()
    {
        return view('extraexpense.create');
    }
    public function store(Request $request)
    {
        $validated = $request->validate([
            'amount' => 'required|numeric',
            'description' => 'nullable|string',
            'expense_date' => 'required|date',
        ]);

        ExtraExpense::create($validated);

        return redirect()->route('extra_expenses.index')->with('success', 'Expense added successfully!');
    }

    
    public function index(Request $request)
    {
        $start_date = $request->get('start_date');
        $end_date = $request->get('end_date');
    
        if ($start_date && $end_date) {
            $expenses = ExtraExpense::whereBetween('expense_date', [$start_date, $end_date])->get();
        } else {
            $expenses = ExtraExpense::orderBy('expense_date', 'desc')->get();
        }
    
        return view('extraexpense.index', compact('expenses', 'start_date', 'end_date'));
    }
    


    // For printing the expenses
    public function printReport(Request $request)
    {   
        //dd($request->all());
        $ids = explode(',', $request->get('ids'));
        $start_date = $request->get('start_date');
        $end_date = $request->get('end_date');
    
        $expenses = ExtraExpense::whereIn('id', $ids)->get();
    
        return view('extraexpense.print', compact('expenses', 'start_date', 'end_date'));
    }
    
}
