<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Bill extends Model
{
    use HasFactory;

    protected $fillable = [
        'bill_number',
        'customer_id',
        'customer_no',
        'customer_name',
        'print_type',
        'price_type',
        'remarks',
        'payment',
        'sale',
        'total_amount',
        'date',
    ];
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    // Relationship: A Bill has many BillItems
    public function billitems()
    {
        return $this->hasMany(BillItem::class);
    }
    public function outsideItems()
{
    return $this->hasMany(OutsideItem::class);
}

    // // Accessor to get total bill amount
    // public function getTotalAmountAttribute()
    // {
    //     return $this->items->sum('amount');
    // }
}
