<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;

class BillItem extends Model
{
    use HasFactory;
    protected $fillable = [
        'bill_id',
        'product_id',
        'qty',
        'sold_as',
        'customer_name',
        'price',
        'retail_price',
        'less_from_retail',
        'sale',
        'amount',
    ];
    public function product()
{
    return $this->belongsTo(Product::class);
}

public function bill()
{
    return $this->belongsTo(Bill::class);
}

}
