<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_name',
        'company_phone',
        'address',
    ];

    // Relationships
    public function demands()
    {
        return $this->hasMany(Demand::class);
    }
    public function suppliers()
{
    return $this->belongsToMany(Supplier::class);
}

}
