<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Demand extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_name',
        'product_name',
        'supplier_name',
        'qty',
        'reminder',
    ];

    // Relationships
    public function company()
    {
        return $this->belongsTo(Company::class);
    }
    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }
}
