<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LedgerItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'ledger_id',
        'stock',
        'total_amount',
        'paid_amount',
        'ledger_date',
        'payment_date'
    ];

    protected $casts = [
        'ledger_date' => 'date',
        'payment_date' => 'date',
        'total_amount' => 'decimal:2',
        'paid_amount' => 'decimal:2',
    ];

    protected $appends = ['due_amount'];

    public function getDueAmountAttribute()
    {
        return $this->total_amount - $this->paid_amount;
    }

    /**
     * Relationship with SupplierLedger
     */
    public function supplierLedger()
    {
        return $this->belongsTo(SupplierLedger::class, 'ledger_id');
    }
}