<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OutsideItem extends Model
{

    // Specify the table name if it doesn't follow the conventional naming (e.g., 'outside_items' for OutsideItems model)
    protected $table = 'outside_items';
     public $timestamps = false;
    
    // Define the mass assignable attributes for security (e.g., when using create() or fill())
    protected $fillable = [
        'product_name',
        'qty',
        'type',
        'price',
        'bill_id',
    ];
    
    // Define the relationship: This model belongs to the Bill model
    public function bill()
    {
        return $this->belongsTo(Bill::class, 'bill_id');  // 'bill_id' is the foreign key in this table, referencing 'id' in the bills table
    }
}
