<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'type',
        'salt',
        'company',
        'categories',
        'batch_number',
        'quantity',
        'image',
        'availability',
        'expiry_date',
        'expiry_alert',
        'low_stock_alert',
        'purchase_from',
        'retail_price',
        'purchase_price',
        'local_price',
        'doctor_price',
        'unit_type',
        'pieces_per_packet',
        'price_per_piece',
    ];

    
    protected $casts = [
        'categories' => 'array',
    ];
    public function billitems()
{
    return $this->hasMany(BillItem::class);
}

}
