<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bills', function (Blueprint $table) {
            $table->id();
            $table->string('bill_number')->unique();
            $table->foreignId('customer_id')
            ->nullable()
            ->constrained('customers')
            ->onDelete('cascade');
            $table->string('customer_no')->unique()->nullable();
            $table->string('customer_name')->unique()->nullable();      
            $table->string('print_type')->nullable();
            $table->text('remarks')->nullable();
            $table->string('payment');
            $table->date('date')->default(now());
            $table->decimal('total_amount', 10, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bills');
    }
};
