<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCreditAdjustmentsTable extends Migration
{
    public function up()
    {
        Schema::create('credit_adjustments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('credit_id');
            $table->decimal('paid_amount', 10, 2)->nullable();
            $table->decimal('due_amount', 10, 2)->nullable();
            $table->date('date')->nullable();
            $table->time('time')->nullable();
            $table->timestamps();

            $table->foreign('credit_id')->references('id')->on('credit_details')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('credit_adjustments');
    }
}
