<?php
use Illuminate\Database\Migrations\Migration;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOutsideItemsTable extends Migration
{
    public function up()
    {
        Schema::create('outside_items', function (Blueprint $table) {
            $table->id();  // Auto-incrementing primary key
            $table->string('product_name');  // String for product name
            $table->integer('qty');  // Integer for quantity
            $table->string('type');  // String for item type
            $table->decimal('price', 8, 2);  // Decimal for price (e.g., 8 total digits, 2 after decimal)
            $table->unsignedBigInteger('bill_id');  
            
            // Foreign key constraint
            $table->foreign('bill_id')->references('id')->on('bills')->onDelete('cascade');  // Assumes 'bills' table has an 'id' column
             $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('outside_items');  // Reverts the migration
    }
}
           
