@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Customer Information Header -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden mb-6">
        <div class="bg-theme px-4 py-3">
            <div class="flex justify-between items-center">
                <h2 class="text-xl font-bold text-white">Customer Credit History - {{ $customer->name }}</h2>
                <a href="{{ url()->previous() }}" class="bg-white hover:bg-gray-100 text-theme font-bold py-1 px-3 rounded text-sm">
                    &larr; Back
                </a>
            </div>
            <div class="mt-2 grid grid-cols-2 md:grid-cols-4 gap-2 text-white text-sm">
                <div>
                    <span class="font-semibold">Phone:</span> {{ $customer->phone ?? 'N/A' }}
                </div>
                <div>
                    <span class="font-semibold">Total Paid:</span>
                    <span class="text-green-200">{{ number_format($paid, 2) }}</span>
                </div>
                <div>
                    <span class="font-semibold">Total Due:</span>
                    <span class="text-red-200">{{ number_format($due, 2) }}</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Transaction History -->
    <div class="mb-6">
        <h3 class="text-lg font-semibold text-theme mb-3">Transaction History</h3>

        @if($records->flatten()->isEmpty())
            <div class="bg-white p-6 rounded-lg shadow-md text-center">
                <p class="text-gray-600">No transactions found for this customer.</p>
            </div>
        @else
            @foreach($records as $date => $items)
            <div class="mb-8 bg-white rounded-lg shadow-md overflow-hidden">
                <div class="bg-gray-100 px-4 py-2 border-b border-gray-200">
                    <h4 class="font-semibold text-theme">
                        {{ \Carbon\Carbon::parse($date)->setTimezone('Asia/Karachi')->format('F j, Y (l)') }}
                    </h4>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Time</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Details</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Paid Amount</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Due Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($items as $item)
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3 text-sm text-gray-500">
            {{ \Carbon\Carbon::parse($item['data']->time)->format('h:i A') }} <!-- Already timezone adjusted -->
        </td>
                                <td class="px-4 py-3">
                                    @if($item['type'] === 'bill')
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                                            Bill
                                        </span>
                                    @else
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                            Payment
                                        </span>
                                    @endif
                                </td>
                                <td class="px-4 py-3">
                                    @if($item['type'] === 'bill')
                                        <div class="font-medium text-theme">Bill #{{ $item['data']->id }}</div>
                                        <div class="text-xs text-gray-500">
                                            @foreach($item['data']->billItems as $billItem)
                                                • {{ $billItem->product->name }} 
                                                ({{ $billItem->qty }} × {{ number_format($billItem->price, 2) }})<br>
                                            @endforeach
                                        </div>
                                    @else
                                        <div class="font-medium text-theme">Payment</div>
                                        <div class="text-xs text-gray-500 leading-5">
                                            <div><strong>Time:</strong> {{ \Carbon\Carbon::parse($item['data']->time)->format('h:i A') }}</div>
                                            @if(!empty($item['data']->notes))
                                                <div><strong>Note:</strong> {{ $item['data']->notes }}</div>
                                            @endif
                                        </div>
                                    @endif
                                </td>
                                <td class="px-4 py-3 text-sm font-semibold text-green-600">
                                    @if($item['type'] === 'bill')
                                        {{ number_format(0, 2) }}
                                    @else
                                        {{ number_format($item['data']->paid_amount, 2) }}
                                    @endif
                                </td>
                                <td class="px-4 py-3 text-sm font-semibold text-red-600">
                                    @if($item['type'] === 'bill')
                                        {{ number_format($item['amount'], 2) }}
                                    @else
                                        {{ number_format($item['data']->due_amount, 2) }}
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endforeach
        @endif
    </div>
</div>

<style>
    .bg-theme {
        background-color: #1d3244;
    }
    .text-theme {
        color: #1d3244;
    }
</style>
@endsection