@extends('layouts.app')

@section('content')
<div class="mx-auto p-6 bg-white shadow rounded print:shadow-none print:bg-transparent print:p-0">

    <div id="receipt">

        <!-- Store Header -->
        <div class="text-center mb-6">
            @if($printSetting->logo_path)
        <img id="headerLogo" src="{{ asset('storage/' . $printSetting->logo_path) }}" alt="Store Logo" class="mx-auto mb-4" style="max-width: 150px; height: auto;">
    @endif
    <h1 id="headerTitle" class="text-3xl font-bold">{{ $printSetting->title }}</h1>
    <p id="headerAddress" class="text-lg text-gray-800 font-bold">{{ $printSetting->address }}</p>
    <p id="headerPhone" class="text-lg text-gray-800 font-bold">Phone: {{ $printSetting->phone }}</p>
        </div>

        <!-- Report Heading -->
        <div class="text-center mb-4">
            <h2 class="text-2xl font-semibold">Cutomer Credit Details</h2>
        </div>

            <div class="overflow-x-auto">
                <table class="min-w-full table-auto border border-gray-300">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="px-4 py-2 border">Customer Name</th>
                            <th class="px-4 py-2 border">Phone</th>
                            <th class="px-4 py-2 border">Due Amount (Rs.)</th>
                            <th class="px-4 py-2 border">Paid Amount</th>
                            <th class="px-4 py-2 border">Date</th>
                        </tr>
                    </thead>
                    <tbody class="font-bold">
                       
                            <tr class="hover:bg-gray-50 ">
                                <td class="px-4 py-2 border fond-bold">{{ $credit->customer->name }}</td>
                                <td class="px-4 py-2 border fond-bold">Rs. {{$credit->customer->phone }}</td>
                                <td class="px-4 py-2 borde fond-boldr">{{ $credit->due_amount  }}</td>
                                <td class="px-4 py-2 border fond-bold">{{ $credit->is_paid  }}</td>
                                <td class="px-4 py-2 border fond-bold">{{ $credit->updated_at  }}</td>
                            </tr>
                       
                    </tbody>
                </table>
            </div>
 <div class="mt-10 pt-4 border-t text-center text-sm text-gray-600 print:text-black">
                <p class="mb-1 font-bold">Software developed by <span class="font-bold text-gray-800">Next Steps Sols Pvt. Ltd.</span></p>
                <p class="mb-1 font-bold">🌐 <a href="https://www.nextstepsols.com" class=" hover:underline" target="_blank">www.nextstepsols.com</a></p>
                <p class='font-bold'>📞 Cell: 0332-0679987</p>
            </div>
    </div>

    <!-- Print Button -->
    <div class="mt-6 flex justify-center print:hidden">
        <button onclick="window.print()" class="bg-green-500 hover:bg-green-600 text-white px-6 py-2 rounded shadow">
            Print
        </button>
    </div>

</div>
@endsection
