@extends('layouts.app')

@section('content')
<div class="p-4">
    <h2 class="text-3xl font-bold text-gray-800 mb-6">All Credit Details</h2>

    <!-- Search Form -->
   <form method="GET" action="{{ route('credit.search') }}" class="mb-6 flex flex-wrap items-center gap-3">
        <div class="flex items-center max-w-xl space-x-2">
            <input type="text" name="search" placeholder="Search by name or phone..." value="{{ request('search') }}"
                   class="w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring focus:ring-blue-200 focus:outline-none" />
            <button type="submit"
                    class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition duration-200">
                Search
            </button>
        </div>
       <a href="{{ route('credit.search', ['filter' => 'high'] + request()->only('search')) }}"
   class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition duration-200">
    High Credit
</a>
<a href="{{ route('credit.search', request()->except('filter')) }}"
   class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition duration-200">
    Reset Filter
</a>

    </form>
    <!-- Table -->
    <div class="w-full overflow-x-auto">
        <table class="min-w-[1000px] table-auto border text-sm text-left whitespace-nowrap shadow-lg rounded-lg overflow-hidden">
            <thead class="bg-gray-200 text-gray-700">
                <tr>
                    <th class="px-4 py-2">ID</th>
                    <th class="px-4 py-2">Customer Name</th>
                    <th class="px-4 py-2">Customer Phone</th>
                    <th class="px-4 py-2">Address</th>
                    <th class="px-4 py-2">Due Amount</th>
                    <th class="px-4 py-2">Paid Amount</th>
                    <th class="px-4 py-2">Date</th>
                    <th class="px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $filteredCredits = request('filter') === 'high'
                        ? $credits->filter(fn($credit) => $credit->due_amount >= 10000)
                        : $credits;
                @endphp

                @forelse ($filteredCredits as $credit)
                    <tr class="border-b hover:bg-gray-50 {{ $credit->due_amount >= 10000 ? 'bg-red-100 text-red-800 font-semibold' : '' }}">
                        <td class="px-4 py-2">{{ $credit->id }}</td>
                        <td class="px-4 py-2">{{ $credit->customer->name }}</td>
                        <td class="px-4 py-2">{{ $credit->customer->phone }}</td>
                        <td class="px-4 py-2">{{ $credit->customer->address }}</td>
                       
                        <td class="px-4 py-2">{{ $credit->due_amount ?? 'N/A' }}</td>
                        <td class="px-4 py-2">{{ $credit->is_paid }}</td>
                        <td class="px-4 py-2">{{ $credit->updated_at }}</td>
                        <td class="px-4 py-2 space-x-2">
                            <button onclick="openModal({{ $credit->id }})"
                                    class="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600">
                                Edit
                            </button>
    
                            <button onclick="openAddDueModal({{ $credit->id }})"
                                    class="bg-yellow-500 text-white px-3 py-1 rounded hover:bg-yellow-600">
                                Add Due
                            </button>
                            <form action="{{ route('credit.delete', $credit->id) }}" method="POST" class="inline-block">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600" onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                            <a href="{{ route('credit.print', $credit->id) }}" target="_blank"
                               class="bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600">
                                Print
                            </a>
                            <a href="{{ route('customer.credit', $credit->customer_id) }}"
                               class="bg-purple-600 text-white px-3 py-1 rounded hover:bg-purple-700">
                                View Details
                            </a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center text-gray-500 py-4">No records found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-40">
        <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-xl relative">
            <button onclick="closeModal()"
                    class="absolute top-2 right-2 text-gray-500 hover:text-gray-700 text-2xl font-bold">
                &times;
            </button>
            <h3 class="text-xl font-semibold mb-4 text-gray-800">Update Due Amount</h3>
            <form id="editForm" method="POST">
                @csrf
                @method('PUT')
                <div class="mb-4">
                    <label for="due_amount" class="block text-sm font-medium text-gray-700">Enter New Amount</label>
                    <input type="number" name="due_amount" id="due_amount" required
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500" />
                </div>
                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700 transition duration-200">
                    Update
                </button>
            </form>
        </div>
    </div>

    <!-- Add Due Modal -->
    <div id="addDueModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-40">
        <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-xl relative">
            <button onclick="closeModal()"
                    class="absolute top-2 right-2 text-gray-500 hover:text-gray-700 text-2xl font-bold">
                &times;
            </button>
            <h3 class="text-xl font-semibold mb-4 text-gray-800">Add Due Amount</h3>
            <form id="addDueForm" method="POST">
                @csrf
                <div class="mb-4">
                    <label for="add_amount" class="block text-sm font-medium text-gray-700">Amount to Add</label>
                    <input type="number" name="add_amount" id="add_amount" required min="1"
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500" />
                </div>
                <button type="submit"
                        class="bg-yellow-600 text-white px-6 py-2 rounded hover:bg-yellow-700 transition duration-200">
                    Add Due
                </button>
            </form>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
    function openEditModal(creditId) {
        const modal = document.getElementById('editModal');
        const form = document.getElementById('editForm');

        // Update form action
        form.action = `/credit/update/${creditId}`;

        // Show modal
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    function openAddDueModal(creditId) {
        const modal = document.getElementById('addDueModal');
        const form = document.getElementById('addDueForm');

        // Update form action
        form.action = `/credit/add-due/${creditId}`;

        // Show modal
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    function closeModal() {
        const editModal = document.getElementById('editModal');
        const addDueModal = document.getElementById('addDueModal');
        
        editModal.classList.add('hidden');
        editModal.classList.remove('flex');
        addDueModal.classList.add('hidden');
        addDueModal.classList.remove('flex');
    }
</script>
@endsection