@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto py-6">
    <h1 class="text-2xl font-bold mb-6">Edit Bill #{{ $bill->bill_number }}</h1>

    <form action="{{ route('bill.update', $bill->id) }}" method="POST">
        @csrf
        @method('PUT')

        <!-- Global Price Type Selector -->
        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Apply Price Type To All Products:</label>
            <select id="global-price-type" name="price_type" class="border p-2 rounded w-full">
                <option value="">Select Price Type For All</option>
                <option value="retail">Retail Price</option>
                <option value="doctor">Doctor Price</option>
                <option value="local">Local Price</option>
                <option value="purchase">Purchase Price</option>
            </select>
        </div>

        @foreach ($bill->billItems as $index => $item)
            @php
                $product = $item->product;
                $qty = $item->qty;
            @endphp

            <div class="border p-4 rounded mb-6 bg-white shadow-sm">
                <h2 class="text-lg font-semibold mb-2">Product {{ $index + 1 }}</h2>

                <input type="hidden" name="products[{{ $index }}][id]" value="{{ $product->id }}">
                <input type="hidden" class="doctor-price" value="{{ $product->doctor_price }}">
                <input type="hidden" class="local-price" value="{{ $product->local_price }}">
                <input type="hidden" class="purchase-price" value="{{ $product->purchase_price }}">
                
                <p><strong>Name:</strong> {{ $product->name }}</p>
                <p><strong>Company:</strong> {{ $product->company }}</p>
                <p><strong>Retail Price:</strong> {{ $product->retail_price }}</p>
                <p><strong>Doctor Price:</strong> {{ $product->doctor_price }}</p>
                <p><strong>Local Price:</strong> {{ $product->local_price }}</p>
                <p><strong>Purchase Price:</strong> {{ $product->purchase_price }}</p>

                <div class="mt-2">
                    <label class="block font-medium">Quantity:</label>
                    <input 
                        type="number" 
                        name="products[{{ $index }}][qty]" 
                        class="border p-2 rounded w-full qty-input" 
                        min="1"
                        value="{{ $qty }}"
                        data-index="{{ $index }}"
                        data-retail="{{ $product->retail_price }}"
                        required
                    >
                </div>

                <div class="mt-2">
                    <label class="block font-medium">Price:</label>
                    <input 
                        type="number" 
                        name="products[{{ $index }}][price]" 
                        class="border p-2 rounded w-full price-input" 
                        min="0"
                        step="0.01"
                        value="{{ $item->price }}"
                        data-index="{{ $index }}"
                        data-retail="{{ $product->retail_price }}"
                        data-doctor="{{ $product->doctor_price }}"
                        data-local="{{ $product->local_price }}"
                        data-purchase="{{ $product->purchase_price }}"
                        required
                    >
                </div>

                <div class="mt-2">
                    <label class="block font-medium">Total Amount (price × qty):</label>
                    <input 
                        type="text" 
                        class="border p-2 rounded w-full total-amount" 
                        readonly
                        id="total-amount-{{ $index }}"
                        value="{{ $item->amount }}"
                    >
                </div>

                <div class="mt-2">
                    <label class="block font-medium">Less from Retail:</label>
                    <input 
                        type="text" 
                        class="border p-2 rounded w-full price-diff" 
                        readonly
                        id="price-diff-{{ $index }}"
                        value="{{ $item->less_from_retail }}"
                    >
                </div>
            </div>
        @endforeach

        <!-- New Date Field -->
        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Bill Date:</label>
            <input 
                type="date" 
                name="date" 
                class="border p-2 rounded w-full" 
                value="{{ old('date', $bill->date ? \Carbon\Carbon::parse($bill->date)->format('Y-m-d') : '') }}"
            >
            <p class="text-sm text-gray-500 mt-1">Leave empty to use current date</p>
        </div>

        <!-- Price Type Field -->
        <!-- <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Price Type:</label>
            <select name="price_type" class="border p-2 rounded w-full">
                <option value="">Select Price Type</option>
                <option value="doctor" {{ old('price_type', $bill->price_type) == 'doctor' ? 'selected' : '' }}>Doctor Price</option>
                <option value="purchase" {{ old('price_type', $bill->price_type) == 'purchase' ? 'selected' : '' }}>Purchase Price</option>
                <option value="local" {{ old('price_type', $bill->price_type) == 'local' ? 'selected' : '' }}>Local Price</option>
            </select>
        </div> -->

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Print Type:</label>
            <select name="print_type" class="border p-2 rounded w-full">
                <option value="by_name" {{ $bill->print_type == 'by_name' ? 'selected' : '' }}>By Name</option>
                <option value="by_salt" {{ $bill->print_type == 'by_salt' ? 'selected' : '' }}>By Salt</option>
            </select>
        </div>

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Remarks:</label>
            <textarea name="remarks" class="border p-2 rounded w-full">{{ $bill->remarks }}</textarea>
        </div>

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Total Amount of All Products:</label>
            <input 
                type="text" 
                id="grand-total" 
                name="grand_total" 
                class="border p-2 rounded w-full font-bold" 
                readonly
                value="{{ $bill->total_amount }}"
            >
        </div>

        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
            Submit & Print Bill
        </button>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Calculate totals when quantity or price changes
    document.querySelectorAll('.qty-input, .price-input').forEach(input => {
        input.addEventListener('input', function() {
            const index = this.dataset.index;
            const qty = parseFloat(document.querySelector(`input[name="products[${index}][qty]"]`).value) || 0;
            const price = parseFloat(document.querySelector(`input[name="products[${index}][price]"]`).value) || 0;
            const retail = parseFloat(this.dataset.retail) || 0;

            // Calculate total and difference
            const total = qty * price;
            const diff = retail - price;

            // Update display fields
            document.getElementById(`total-amount-${index}`).value = total.toFixed(2);
            document.getElementById(`price-diff-${index}`).value = diff.toFixed(2);

            // Update grand total
            updateGrandTotal();
        });
    });

    // Global price type change handler
    document.getElementById('global-price-type').addEventListener('change', function() {
        const priceType = this.value;
        if (!priceType) return;

        document.querySelectorAll('.price-input').forEach(input => {
            const price = input.dataset[priceType];
            if (price) {
                input.value = price;
                const index = input.dataset.index;
                
                // Trigger calculation for this product
                const qty = parseFloat(document.querySelector(`input[name="products[${index}][qty]"]`).value) || 0;
                const retail = parseFloat(input.dataset.retail) || 0;
                
                const total = qty * price;
                const diff = retail - price;

                document.getElementById(`total-amount-${index}`).value = total.toFixed(2);
                document.getElementById(`price-diff-${index}`).value = diff.toFixed(2);
            }
        });

        updateGrandTotal();
    });

    function updateGrandTotal() {
        let grandTotal = 0;
        document.querySelectorAll('.total-amount').forEach(input => {
            grandTotal += parseFloat(input.value) || 0;
        });
        document.getElementById('grand-total').value = grandTotal.toFixed(2);
    }
});
</script>
@endsection