@extends('layouts.app')

@section('content')
<div class="max-w-3xl mx-auto p-6 bg-white shadow rounded print:shadow-none print:bg-transparent print:p-0">
    
<div id="receipt">
    <!-- Header Section -->
      <div id="storeHeader" class="text-center mb-6">
    @if($printSetting->logo_path)
        <img src="{{ asset('storage/' . $printSetting->logo_path) }}" alt="Store Logo" class="mx-auto mb-4" style="max-width: 150px; height: auto;">
    @endif
    <h1 class="text-3xl font-bold">{{ $printSetting->title }}</h1>
    <p class="text-sm text-gray-700">{{ $printSetting->address }}</p>
    <p class="text-sm text-gray-700">Phone: {{ $printSetting->phone }}</p>
    </div>

     <div class="max-w-6xl mx-auto p-6">
    <h2 class="text-2xl font-bold text-center text-gray-800 mb-6">
        🧾 Counter Close Summary ({{ \Carbon\Carbon::now()->format('d M Y') }})
    </h2>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Total Sales -->
        <div class="bg-green-500 text-white rounded-xl shadow-lg p-5">
            <h5 class="text-lg font-semibold">Total Sales</h5>
            <p>Quantity: <strong>{{ $totalSalesQty }}</strong></p>
            <p>Amount: <strong>Rs. {{ number_format($totalSalesAmount, 2) }}</strong></p>
        </div>

        <!-- Credit Sales -->
        <div class="bg-yellow-400 text-gray-900 rounded-xl shadow-lg p-5">
            <h5 class="text-lg font-semibold">Credit Sales</h5>
            <p>Amount: <strong>Rs. {{ number_format($creditAmount, 2) }}</strong></p>
        </div>

        <!-- Extra Expenses -->
        <div class="bg-red-500 text-white rounded-xl shadow-lg p-5">
            <h5 class="text-lg font-semibold">Extra Expenses</h5>
            <p>Amount: <strong>Rs. {{ number_format($extraExpenseAmount, 2) }}</strong></p>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
        <!-- Profit -->
        <div class="bg-blue-400 text-white rounded-xl shadow-lg p-5">
            <h5 class="text-lg font-semibold">Profit</h5>
            <p>Amount: <strong>Rs. {{ number_format($profit, 2) }}</strong></p>
        </div>

        <!-- Credit Customers -->
       
        <div class="bg-indigo-600 text-white rounded-xl shadow-lg p-5">
            <h5 class="text-lg font-semibold mb-3">Paid To Supplier</h5>
            
               
                
                   
                    <p>Amount: <strong>Rs. {{ number_format($totalSupplierPayments, 2) }}</strong></p>
               
                
            
        </div>
    </div>

   
  <!-- Footer Info Section -->
   <div id="storeFooter" class="mt-6 text-sm text-gray-700">
    <p><strong>Note:</strong> {{ $printSetting->footer_note }}</p>
    </div>

<!-- Goodbye Message -->
     <div id="goodbye" class="mt-6 text-center font-semibold">
    <p>{{ $printSetting->goodbye_message }}</p>
     </div>
    </div>
   <!-- Buttons -->
   
</div>
<div class="mt-6 flex justify-center space-x-4 print:hidden">
<button onclick="handlePrint()" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
Print
 </button>
</div>
</div>
@endsection
