@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto mt-10 p-4 sm:p-6 bg-white rounded-xl shadow-md">
    <h2 class="text-2xl font-semibold mb-6 text-center sm:text-left">My Profile</h2>

    <!-- Responsive Table or Stacked Info -->
    <div class="overflow-x-auto hidden sm:block">
        <table class="min-w-full border text-left text-sm mb-8">
            <thead class="bg-gray-100 text-gray-700">
                <tr>
                    <th class="py-2 px-4 border-b">Name</th>
                    <th class="py-2 px-4 border-b">Email</th>
                    <th class="py-2 px-4 border-b">Role</th>
                    <th class="py-2 px-4 border-b">Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="py-2 px-4 border-b">{{ $user->name }}</td>
                    <td class="py-2 px-4 border-b">{{ $user->email }}</td>
                    <td class="py-2 px-4 border-b capitalize">{{ $user->role }}</td>
                    <td class="py-2 px-4 border-b">
                        <a href="{{ route('profile.edit') }}" class="bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded">Edit</a>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Stacked view for mobile -->
    <div class="sm:hidden space-y-4 mb-8">
        <div class="border rounded p-4 shadow-sm bg-gray-50">
            <p><strong>Name:</strong> {{ $user->name }}</p>
            <p><strong>Email:</strong> {{ $user->email }}</p>
            <p><strong>Role:</strong> <span class="capitalize">{{ $user->role }}</span></p>
            <a href="{{ route('profile.edit') }}"  target="_blank" class="inline-block mt-3 bg-yellow-500 hover:bg-yellow-600 text-white px-4 py-2 rounded">Edit</a>
        </div>
    </div>

    <!-- Change Password Section -->
    <div>
        <h3 class="text-xl font-semibold mb-4">Change Password</h3>

        @if (session('success'))
            <div class="mb-4 p-3 bg-green-100 text-green-700 rounded">
                {{ session('success') }}
            </div>
        @endif

        @if ($errors->any())
            <div class="mb-4 p-3 bg-red-100 text-red-700 rounded">
                <ul class="list-disc ml-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('profile.change-password') }}">
            @csrf

            <div class="mb-4">
                <label class="block mb-1 font-medium">Current Password</label>
                <input type="password" name="current_password" class="w-full border px-3 py-2 rounded" required>
            </div>

            <div class="mb-4">
                <label class="block mb-1 font-medium">New Password</label>
                <input type="password" name="new_password" class="w-full border px-3 py-2 rounded" required>
            </div>

            <div class="mb-6">
                <label class="block mb-1 font-medium">Confirm New Password</label>
                <input type="password" name="new_password_confirmation" class="w-full border px-3 py-2 rounded" required>
            </div>

            <button type="submit" class="w-full sm:w-auto bg-blue-600 hover:bg-blue-700 text-white font-semibold px-6 py-2 rounded">
                Update Password
            </button>
        </form>
    </div>
</div>
@endsection
