@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Animal Receipts</h1>
        
        <!-- Search Bar -->
        <div class="w-full md:w-1/3 mt-4 md:mt-0">
            <form action="{{ route('receipt.index') }}" method="GET">
                <div class="relative">
                    <input type="text" name="search" value="{{ request('search') }}" 
                           class="w-full pl-10 pr-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" 
                           placeholder="Search by Patient No, Contact, Farmer...">
                    <div class="absolute left-3 top-2.5">
                        <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Table Container -->
    <div class="bg-white shadow-md rounded-lg overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Patient No</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Farmer Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Animal</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Animal Tag No</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reffered By</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Gender</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Contact</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach($receipts as $receipt)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $receipt->patient_no }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $receipt->date }} {{ $receipt->time }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $receipt->farmer_name }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 capitalize">{{ $receipt->animal }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 capitalize">{{ $receipt->animal_tag_no }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 capitalize">{{ $receipt->referred_by }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 capitalize">{{ $receipt->gender }}</td>  
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $receipt->contact_no }}</td>
                    
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <button onclick="openEditModal({{ json_encode($receipt) }})" 
                                class="text-blue-600 hover:text-blue-900 mr-3">Select</button>
                        <form action="{{ route('receipt.destroy', $receipt->id) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:text-red-900" 
                                    onclick="return confirm('Are you sure you want to delete this receipt?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        {{ $receipts->links() }}
    </div>
</div>

<!-- Edit Modal -->
<div id="editModal" class="fixed z-10 inset-0 overflow-y-auto hidden">
    <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 transition-opacity" aria-hidden="true">
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
        <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
            <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Edit Receipt</h3>
              <form id="editForm" method="POST" enctype="multipart/form-data">
    @csrf
    @method('PUT')
    <div class="grid grid-cols-1 gap-6">
        <!-- Patient Number (Read-only) -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-bold mb-2">Patient Number</label>
            <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 bg-gray-100" 
                   id="edit_patient_no" name="patient_no" type="text" readonly>
        </div>
        
        <!-- Findings Text Area -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-bold mb-2">Findings</label>
            <textarea class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                      id="edit_finding" name="finding" rows="4" placeholder="Enter findings"></textarea>
        </div>
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-bold mb-2">Suspected Diagnosis</label>
            <textarea class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                      id="edit_diagnosis" name="diagnosis" rows="4" placeholder="Enter Diagnosis"></textarea>
        </div>
        
        <!-- Image Upload with Preview -->
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-bold mb-2">Image</label>
            
            <!-- Current Image Preview -->
            <div id="currentImageContainer" class="mb-4 hidden">
                <p class="text-sm text-gray-600 mb-2">Current Image:</p>
                <img id="currentImagePreview" src="" alt="Current Receipt Image" class="max-w-full h-48 object-contain border rounded">
            </div>
            
            <!-- New Image Upload -->
            <div class="flex items-center">
                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                       id="edit_image" name="image" type="file" accept="image/*" onchange="previewImage(this)">
                
                <!-- Image Preview (for new selection) -->
                <div id="imagePreviewContainer" class="ml-4 hidden">
                    <p class="text-sm text-gray-600 mb-2">New Image Preview:</p>
                    <img id="imagePreview" src="#" alt="Image Preview" class="max-w-full h-24 object-contain border rounded">
                </div>
            </div>
            
            <!-- Remove Image Checkbox -->
            <div id="removeImageContainer" class="mt-2 hidden">
                <label class="inline-flex items-center">
                    <input type="checkbox" name="remove_image" class="form-checkbox">
                    <span class="ml-2 text-sm text-gray-700">Remove current image</span>
                </label>
            </div>
        </div>
    </div>
    
    <!-- Form Actions -->
    <div class="mt-6 flex justify-end">
        <button type="button" onclick="closeEditModal()" 
                class="mr-2 bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded transition duration-200">
            Cancel
        </button>
        <button type="submit" 
                class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded transition duration-200">
            Update Receipt
        </button>
    </div>
</form>
            </div>
        </div>
    </div>
</div>

<script>
    function openEditModal(receipt) {
        // Populate form fields
        document.getElementById('edit_patient_no').value = receipt.patient_no;
        document.getElementById('edit_finding').value = receipt.finding || '';
          document.getElementById('edit_diagnosis').value = receipt.diagnosis || '';
        
        // Handle image preview
        const currentImageContainer = document.getElementById('currentImageContainer');
        const removeImageContainer = document.getElementById('removeImageContainer');
        
        if (receipt.image) {
            currentImageContainer.classList.remove('hidden');
            document.getElementById('currentImagePreview').src = '/storage/' + receipt.image;
            removeImageContainer.classList.remove('hidden');
        } else {
            currentImageContainer.classList.add('hidden');
            removeImageContainer.classList.add('hidden');
        }
        
        // Clear any previous image preview
        document.getElementById('imagePreviewContainer').classList.add('hidden');
        document.getElementById('edit_image').value = '';
        
        // Set form action
        document.getElementById('editForm').action = `/receipt/update/${receipt.id}`;
        
        // Show modal
        document.getElementById('editModal').classList.remove('hidden');
    }
    
    function previewImage(input) {
        const previewContainer = document.getElementById('imagePreviewContainer');
        const preview = document.getElementById('imagePreview');
        
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                preview.src = e.target.result;
                previewContainer.classList.remove('hidden');
            }
            
            reader.readAsDataURL(input.files[0]);
        } else {
            previewContainer.classList.add('hidden');
        }
    }
    
    function closeEditModal() {
        document.getElementById('editModal').classList.add('hidden');
    }
</script>

<style>
    /* Make table scrollable on small screens */
    @media (max-width: 640px) {
        .overflow-x-auto {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
    }
</style>
@endsection