<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Faisal Veterinary Store</title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet"/>
  <style>
    .theme-bg {
      background-color: #1d3244;
    }
  </style>
</head>
<body class="bg-white min-h-screen flex flex-col">

  <!-- Navbar -->
  <nav class="flex items-center justify-between px-6 py-4 theme-bg shadow-md h-16">
    <!-- Left: Title -->
    <div class="flex-1 text-white text-base sm:text-lg md:text-xl lg:text-2xl font-bold truncate">
      Faisal Veterinary Store
    </div>

    <!-- Center: Logo -->
    <div class="flex justify-center">
      <img src="{{ asset('images/logo.png') }}" alt="Logo" class="h-10 w-auto rounded-full">
    </div>

    <!-- Right: Links -->
    <div class="flex-1 flex justify-end space-x-4">
      <a href="{{ route('login.index') }}" class="text-white font-medium hover:text-yellow-300 transition">
        Login
      </a>
      <a href="{{ route('register.index') }}" class="text-white font-medium hover:text-yellow-300 transition">
        Register
      </a>
    </div>
  </nav>

  <!-- Hero Section -->
  <div class="flex-1 flex flex-col md:flex-row items-center justify-center gap-8 px-6 py-10">
    
    <!-- Left: Image Container -->
    <div class="md:w-1/2 w-full flex justify-center">
      <img src="{{ asset('images/logo.png') }}" alt="Veterinary Image" class="rounded-xl shadow-lg max-w-xs md:max-w-md w-full">
    </div>

    <!-- Right: Welcome Message -->
    <div class="md:w-1/2 w-full theme-bg text-white p-8 rounded-xl shadow-lg text-center">
      <h1 class="text-3xl md:text-4xl font-extrabold leading-tight mb-6">
        Welcome to the Faisal Veterinary Store
      </h1>
      <a href="{{ route('dashboard') }}" class="inline-block mt-4 px-6 py-3 bg-yellow-400 text-black text-lg font-semibold rounded-lg shadow hover:bg-yellow-500 transition">
        Access Admin Panel
      </a>
    </div>

  </div>

</body>
</html>
