<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto py-6">
    <h1 class="text-2xl font-bold mb-6">Edit Bill #<?php echo e($bill->bill_number); ?></h1>

    <form action="<?php echo e(route('bill.update', $bill->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <!-- Global Price Type Selector -->
        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Apply Price Type To All Products:</label>
            <select id="global-price-type" name="price_type" class="border p-2 rounded w-full">
                <option value="">Select Price Type For All</option>
                <option value="retail">Retail Price</option>
                <option value="doctor">Doctor Price</option>
                <option value="local">Local Price</option>
                <option value="purchase">Purchase Price</option>
            </select>
        </div>

        <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $product = $item->product;
                $qty = $item->qty;
            ?>

            <div class="border p-4 rounded mb-6 bg-white shadow-sm">
                <h2 class="text-lg font-semibold mb-2">Product <?php echo e($index + 1); ?></h2>

                <input type="hidden" name="products[<?php echo e($index); ?>][id]" value="<?php echo e($product->id); ?>">
                <input type="hidden" class="doctor-price" value="<?php echo e($product->doctor_price); ?>">
                <input type="hidden" class="local-price" value="<?php echo e($product->local_price); ?>">
                <input type="hidden" class="purchase-price" value="<?php echo e($product->purchase_price); ?>">
                
                <p><strong>Name:</strong> <?php echo e($product->name); ?></p>
                <p><strong>Company:</strong> <?php echo e($product->company); ?></p>
                <p><strong>Retail Price:</strong> <?php echo e($product->retail_price); ?></p>
                <p><strong>Doctor Price:</strong> <?php echo e($product->doctor_price); ?></p>
                <p><strong>Local Price:</strong> <?php echo e($product->local_price); ?></p>
                <p><strong>Purchase Price:</strong> <?php echo e($product->purchase_price); ?></p>

                <div class="mt-2">
                    <label class="block font-medium">Quantity:</label>
                    <input 
                        type="number" 
                        name="products[<?php echo e($index); ?>][qty]" 
                        class="border p-2 rounded w-full qty-input" 
                        min="1"
                        value="<?php echo e($qty); ?>"
                        data-index="<?php echo e($index); ?>"
                        data-retail="<?php echo e($product->retail_price); ?>"
                        required
                    >
                </div>

                <div class="mt-2">
                    <label class="block font-medium">Price:</label>
                    <input 
                        type="number" 
                        name="products[<?php echo e($index); ?>][price]" 
                        class="border p-2 rounded w-full price-input" 
                        min="0"
                        step="0.01"
                        value="<?php echo e($item->price); ?>"
                        data-index="<?php echo e($index); ?>"
                        data-retail="<?php echo e($product->retail_price); ?>"
                        data-doctor="<?php echo e($product->doctor_price); ?>"
                        data-local="<?php echo e($product->local_price); ?>"
                        data-purchase="<?php echo e($product->purchase_price); ?>"
                        required
                    >
                </div>

                <div class="mt-2">
                    <label class="block font-medium">Total Amount (price × qty):</label>
                    <input 
                        type="text" 
                        class="border p-2 rounded w-full total-amount" 
                        readonly
                        id="total-amount-<?php echo e($index); ?>"
                        value="<?php echo e($item->amount); ?>"
                    >
                </div>

                <div class="mt-2">
                    <label class="block font-medium">Less from Retail:</label>
                    <input 
                        type="text" 
                        class="border p-2 rounded w-full price-diff" 
                        readonly
                        id="price-diff-<?php echo e($index); ?>"
                        value="<?php echo e($item->less_from_retail); ?>"
                    >
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- New Date Field -->
        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Bill Date:</label>
            <input 
                type="date" 
                name="date" 
                class="border p-2 rounded w-full" 
                value="<?php echo e(old('date', $bill->date ? \Carbon\Carbon::parse($bill->date)->format('Y-m-d') : '')); ?>"
            >
            <p class="text-sm text-gray-500 mt-1">Leave empty to use current date</p>
        </div>

        <!-- Price Type Field -->
        <!-- <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Price Type:</label>
            <select name="price_type" class="border p-2 rounded w-full">
                <option value="">Select Price Type</option>
                <option value="doctor" <?php echo e(old('price_type', $bill->price_type) == 'doctor' ? 'selected' : ''); ?>>Doctor Price</option>
                <option value="purchase" <?php echo e(old('price_type', $bill->price_type) == 'purchase' ? 'selected' : ''); ?>>Purchase Price</option>
                <option value="local" <?php echo e(old('price_type', $bill->price_type) == 'local' ? 'selected' : ''); ?>>Local Price</option>
            </select>
        </div> -->

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Print Type:</label>
            <select name="print_type" class="border p-2 rounded w-full">
                <option value="by_name" <?php echo e($bill->print_type == 'by_name' ? 'selected' : ''); ?>>By Name</option>
                <option value="by_salt" <?php echo e($bill->print_type == 'by_salt' ? 'selected' : ''); ?>>By Salt</option>
            </select>
        </div>

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Remarks:</label>
            <textarea name="remarks" class="border p-2 rounded w-full"><?php echo e($bill->remarks); ?></textarea>
        </div>

        <div class="border p-4 rounded mb-6 bg-white shadow-sm">
            <label class="block font-medium">Total Amount of All Products:</label>
            <input 
                type="text" 
                id="grand-total" 
                name="grand_total" 
                class="border p-2 rounded w-full font-bold" 
                readonly
                value="<?php echo e($bill->total_amount); ?>"
            >
        </div>

        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
            Submit & Print Bill
        </button>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Calculate totals when quantity or price changes
    document.querySelectorAll('.qty-input, .price-input').forEach(input => {
        input.addEventListener('input', function() {
            const index = this.dataset.index;
            const qty = parseFloat(document.querySelector(`input[name="products[${index}][qty]"]`).value) || 0;
            const price = parseFloat(document.querySelector(`input[name="products[${index}][price]"]`).value) || 0;
            const retail = parseFloat(this.dataset.retail) || 0;

            // Calculate total and difference
            const total = qty * price;
            const diff = retail - price;

            // Update display fields
            document.getElementById(`total-amount-${index}`).value = total.toFixed(2);
            document.getElementById(`price-diff-${index}`).value = diff.toFixed(2);

            // Update grand total
            updateGrandTotal();
        });
    });

    // Global price type change handler
    document.getElementById('global-price-type').addEventListener('change', function() {
        const priceType = this.value;
        if (!priceType) return;

        document.querySelectorAll('.price-input').forEach(input => {
            const price = input.dataset[priceType];
            if (price) {
                input.value = price;
                const index = input.dataset.index;
                
                // Trigger calculation for this product
                const qty = parseFloat(document.querySelector(`input[name="products[${index}][qty]"]`).value) || 0;
                const retail = parseFloat(input.dataset.retail) || 0;
                
                const total = qty * price;
                const diff = retail - price;

                document.getElementById(`total-amount-${index}`).value = total.toFixed(2);
                document.getElementById(`price-diff-${index}`).value = diff.toFixed(2);
            }
        });

        updateGrandTotal();
    });

    function updateGrandTotal() {
        let grandTotal = 0;
        document.querySelectorAll('.total-amount').forEach(input => {
            grandTotal += parseFloat(input.value) || 0;
        });
        document.getElementById('grand-total').value = grandTotal.toFixed(2);
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/bill/edit.blade.php ENDPATH**/ ?>