
<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto p-6 bg-white rounded-xl shadow-md mt-10 overflow-x-auto border border-gray-200">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Product Records</h2>
        <a href="<?php echo e(route('product.create')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white font-semibold px-6 py-2 rounded">
            Add Product
        </a>
    </div>
    <form method="GET" action="<?php echo e(route('product.index', $filter)); ?>" class="mb-6">
    <div class="flex items-center space-x-2">
        <input type="text" name="search" value="<?php echo e(request('search')); ?>"
               placeholder="Search by name or company..."
               class="w-full px-4 py-2 border border-gray-300 rounded shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-300">
        <button type="submit"
                class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
            Search
        </button>
    </div>
</form>
    <?php if(session('success')): ?>
        <div class="mb-4 p-3 bg-green-100 text-green-700 rounded">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="mb-4 p-3 bg-red-100 text-red-700 rounded">
            <ul class="list-disc ml-5">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <?php if($products->count()): ?>
    <table class="min-w-full border text-left text-sm rounded">
        <thead class=" text-black-700 text-sm font-semibold uppercase">
            <tr>
          

                <th class="py-2 px-4 border-b">Product Name</th>
                <th class="py-2 px-4 border-b">Categories</th>
                <th class="py-2 px-4 border-b">Company</th>
                <th class="py-2 px-4 border-b">Batch No</th>
                <th class="py-2 px-4 border-b">Expiry Date</th>
                <th class="py-2 px-4 border-b">Quantity</th>
                <th class="py-2 px-4 border-b">Unit-Type</th>
                <th class="py-2 px-4 border-b">Purchase Price</th>
                <th class="py-2 px-4 border-b">Retail Price</th>
                <th class="py-2 px-4 border-b">Local Price</th>
                <th class="py-2 px-4 border-b">Doctor Price</th>
                <th class="py-2 px-4 border-b">Piece Price</th>
                <th class="py-2 px-4 border-b">Image</th>
                <th class="py-2 px-4 border-b">Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr class="border-b <?php echo e($product->is_near_expiry ? 'bg-yellow-100' : ''); ?> hover:bg-gray-50 transition duration-200">
            <td class="py-2 px-4"><?php echo e($product->name); ?></td>
            <td class="py-2 px-4">
                <?php $__currentLoopData = $product->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="inline-block bg-gray-200 text-gray-800 text-xs px-2 py-1 rounded mr-1"><?php echo e($category); ?></span>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </td>
            <td class="py-2 px-4"><?php echo e($product->company); ?></td>
            <td class="py-2 px-4"><?php echo e($product->batch_number); ?></td>
            <td class="py-2 px-4"><?php echo e($product->expiry_date); ?></td>
            <td class="py-2 px-4"><?php echo e($product->quantity); ?></td>
            <td class="py-2 px-4"><?php echo e($product->unit_type); ?></td>
            <td class="py-2 px-4"><?php echo e($product->purchase_price); ?></td>
            <td class="py-2 px-4"><?php echo e($product->retail_price); ?></td>
            <td class="py-2 px-4"><?php echo e($product->local_price); ?></td>
            <td class="py-2 px-4"><?php echo e($product->doctor_price); ?></td>
            <td class="py-2 px-4"><?php echo e($product->price_per_piece); ?></td>
            <td class="py-2 px-4">
                <?php if($product->image): ?>
                    <img src="<?php echo e(asset('storage/' . $product->image)); ?>" alt="Product Image"
                         class="w-12 h-12 rounded shadow border border-gray-300 object-cover">
                <?php else: ?>
                    <span class="text-gray-400 text-sm">No Image</span>
                <?php endif; ?>
            </td>
            <td class="py-2 px-4">
    <div class="flex flex-wrap gap-2">
        <a href="<?php echo e(route('product.edit', $product->id)); ?>"
           class="bg-green-500 hover:bg-green-600 text-white px-3 py-1 rounded text-xs font-semibold">
            Edit
        </a>
        <form action="<?php echo e(route('product.delete', $product->id)); ?>" method="POST" onsubmit="return confirm('Are you sure?')">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button type="submit"
                    class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded text-xs font-semibold">
                Delete
            </button>
        </form>
        <a href="<?php echo e(route('products.sales', $product->id)); ?>"
           class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded text-xs font-semibold">
            Sales
        </a>
    </div>
</td>


        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       
        </tbody>
        
       
    </table>

    <!-- Color legend -->
    <div class="mt-6 flex flex-col md:flex-row items-center justify-center gap-4 text-sm text-gray-600">
    <div class="flex items-center gap-2">
        <span class="inline-block w-4 h-4 bg-yellow-100 border border-gray-300 rounded"></span>
        <span>Near Expiry Product</span>
    </div>
    <a href="<?php echo e(route('product.print')); ?>"
       class="bg-purple-600 hover:bg-purple-700 text-white font-semibold px-6 py-2 rounded shadow">
       Print All
    </a>
</div>

    <?php else: ?>
        <p class="text-gray-600 mt-4">No products found.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\product\index.blade.php ENDPATH**/ ?>