<?php $__env->startSection('content'); ?>
<div class="p-4">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold">Outside Purchase Bills</h2>
        
        <!-- Search Form -->
        <form method="GET" action="<?php echo e(route('outside-bills.index')); ?>" class="flex items-center gap-2">
            <input type="hidden" name="status" value="<?php echo e(request('status', 'completed')); ?>">

            <div class="relative">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by customer, bill #, product..." 
                    class="px-4 py-2 border border-gray-300 rounded shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-300 text-sm"
                    value="<?php echo e(request('search')); ?>"
                >
            </div>

            <select name="search_type" class="border px-2 py-2 rounded text-sm">
                <option value="all" <?php echo e(request('search_type') == 'all' ? 'selected' : ''); ?>>All Fields</option>
                <option value="customer" <?php echo e(request('search_type') == 'customer' ? 'selected' : ''); ?>>Customer Name</option>
                <option value="bill_number" <?php echo e(request('search_type') == 'bill_number' ? 'selected' : ''); ?>>Bill Number</option>
                <option value="bill_id" <?php echo e(request('search_type') == 'bill_id' ? 'selected' : ''); ?>>Bill ID</option>
                <option value="product" <?php echo e(request('search_type') == 'product' ? 'selected' : ''); ?>>Product Name</option>
            </select>

            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded text-sm">
                Search
            </button>

            <?php if(request()->has('search')): ?>
                <a href="<?php echo e(route('outside-bills.index', ['status' => request('status', 'completed')])); ?>" 
                   class="text-gray-500 hover:text-gray-700 text-sm">
                    Clear
                </a>
            <?php endif; ?>
        </form>
    </div>

    <div class="w-full overflow-hidden">
        <div class="max-h-[calc(100vh-200px)] overflow-y-auto">
            <table class="min-w-[1000px] table-auto border text-sm text-left whitespace-nowrap">
                <thead class="bg-gray-100 sticky top-0 z-10">
                    <tr>
                        <th class="px-4 py-2">Bill No</th>
                        <th class="px-4 py-2">Customer Name</th>
                        <th class="px-4 py-2">Product Name</th>
                        <th class="px-4 py-2">Type</th>
                        <th class="px-4 py-2">Price</th>
                        <th class="px-4 py-2">Quantity</th>
                        <th class="px-4 py-2">Total</th>
                        <th class="px-4 py-2">Payment Type</th>
                        <th class="px-4 py-2">Date</th>
                        <th class="px-4 py-2">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $outsideItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-b">
                            <td class="px-4 py-2"><?php echo e($item->bill->id); ?></td>
                            <td class="px-4 py-2"><?php echo e($item->bill->customer_name); ?></td>
                            <td class="px-4 py-2"><?php echo e($item->product_name); ?></td>
                            <td class="px-4 py-2"><?php echo e($item->type); ?></td>
                            <td class="px-4 py-2"><?php echo e($item->price); ?></td>
                            <td class="px-4 py-2"><?php echo e($item->qty); ?></td>
                            <td class="px-4 py-2"><?php echo e($item->qty * $item->price); ?></td>
                            <td class="px-4 py-2"><?php echo e($item->bill->payment); ?></td>
                            <td class="px-4 py-2"><?php echo e($item->bill->date); ?></td>
                            <td class="px-4 py-2 space-x-2">
                                <a href="<?php echo e(route('print.view', $item->bill->id)); ?>" 
                                   class="bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600">Print</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10" class="px-4 py-2 text-center text-gray-500">
                                No outside bills found matching your search criteria
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <?php if($outsideItems->hasPages()): ?>
            <div class="mt-4">
                <?php echo e($outsideItems->appends(request()->query())->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/bill/outside-bill.blade.php ENDPATH**/ ?>