<?php $__env->startSection('content'); ?>
<div class="p-4">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold">All Bill Details</h2>
        
        <!-- Search Form -->
        <form method="GET" action="<?php echo e(route('bill.details')); ?>" class="w-full flex flex-col sm:flex-row items-stretch sm:items-center gap-2">
    <input type="hidden" name="status" value="<?php echo e(request('status', 'completed')); ?>">

    <div class="relative w-full">
        <input 
            type="text" 
            name="search" 
            id="liveBillSearchInput"
            placeholder="Search by customer, bill #, product..." 
            class="w-full px-4 py-2 border border-gray-300 rounded shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-300 text-sm"
            value="<?php echo e(request('search')); ?>"
            oninput="handleBillLiveSearch(this.value)"
            autocomplete="off"
        >
        <!-- Suggestion box -->
        <div id="billLiveResultContainer"
             class="absolute top-full left-0 w-full bg-white border border-gray-300 rounded shadow text-sm z-20 hidden max-h-64 overflow-y-auto">
        </div>
    </div>

    <select name="search_type" class="border px-2 py-2 rounded text-sm">
        <option value="all" <?php echo e(request('search_type') == 'all' ? 'selected' : ''); ?>>All Fields</option>
        <option value="customer" <?php echo e(request('search_type') == 'customer' ? 'selected' : ''); ?>>Customer Name</option>
        <option value="bill_number" <?php echo e(request('search_type') == 'bill_number' ? 'selected' : ''); ?>>Bill Number</option>
        <option value="bill_id" <?php echo e(request('search_type') == 'bill_id' ? 'selected' : ''); ?>>Bill ID</option>
        <option value="product" <?php echo e(request('search_type') == 'product' ? 'selected' : ''); ?>>Product Name</option>
    </select>

    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded text-sm">
        Search
    </button>

    <?php if(request()->has('search')): ?>
        <a href="<?php echo e(route('bill.details', ['status' => request('status', 'completed')])); ?>" 
           class="text-gray-500 hover:text-gray-700 text-sm">
            Clear
        </a>
    <?php endif; ?>
</form>
    </div>

    <div class="w-full overflow-auto">
        <table class="min-w-[1000px] table-auto border text-sm text-left whitespace-nowrap">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-2">Bill No</th>
                    <th class="px-4 py-2">Customer Name</th>
                    <th class="px-4 py-2">Product Name</th>
                    <th class="px-4 py-2">Product Price</th>
                    <th class="px-4 py-2">Retail Price</th>
                    <th class="px-4 py-2">Less from Retail</th>
                    <th class="px-4 py-2">Quantity</th>
                    <th class="px-4 py-2">Product Total Price</th>
                    <th class="px-4 py-2">payment_Type</th>
                    <th class="px-4 py-2">Grand Total</th>
                    <th class="px-4 py-2">Date</th>
                    <th class="px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
               <?php $__empty_1 = true; $__currentLoopData = $bills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b">
                        <td class="px-4 py-2"><?php echo e($bill->id); ?></td>
                        <td class="px-4 py-2"><?php echo e($bill->customer_name); ?></td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->product->name ?? 'N/A'); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->price?? 'N/A'); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->retail_price); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->less_from_retail); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->qty); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->amount); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2"><?php echo e($bill->payment ?? 'N/A'); ?></td>
                        <td class="px-4 py-2 font-bold"><?php echo e($bill->total_amount); ?></td>
                        <td class="px-4 py-2"><?php echo e($bill->date); ?></td>
                        <!-- In resources/views/bill/bill-details.blade.php -->
<td class="px-4 py-2 space-x-2">
    <?php if($bill->status === 'pending'): ?>
        <a href="<?php echo e(route('bill.edit', $bill->id)); ?>" 
           class="bg-yellow-500 text-white px-3 py-1 rounded hover:bg-yellow-600">Complete</a>
    <?php endif; ?>
    <a href="<?php echo e(route('print.view', $bill->id)); ?>" 
       class="bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600">Print</a>
</td>
                    </tr>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="12" class="px-4 py-2 text-center text-gray-500">
                            No bills found matching your search criteria
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <?php if($bills->hasPages()): ?>
            <div class="mt-4">
                <?php echo e($bills->appends(request()->query())->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
    <div class="bg-white rounded-lg p-6 max-w-4xl mx-auto my-10 max-h-[90vh] overflow-y-auto">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-xl font-bold">Edit Bill</h3>
            <button onclick="closeModal()" class="text-gray-500 hover:text-gray-700">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>
        <div id="modalContent">
            <!-- Content will be loaded here via AJAX -->
        </div>
    </div>
</div>

<script>
function openEditModal(billId) {
    fetch(`/bills/${billId}/edit`)
        .then(response => response.text())
        .then(html => {
            document.getElementById('modalContent').innerHTML = html;
            document.getElementById('editModal').classList.remove('hidden');
        });
}

function closeModal() {
    document.getElementById('editModal').classList.add('hidden');
}

// Add click handler to edit buttons
document.querySelectorAll('.edit-btn').forEach(btn => {
    btn.addEventListener('click', function(e) {
        e.preventDefault();
        openEditModal(this.dataset.billId);
    });
});
let billSelectedIndex = -1;
let billSuggestions = [];

function handleBillLiveSearch(query) {
    const resultBox = document.getElementById('billLiveResultContainer');

    if (query.length < 1) {
        resultBox.classList.add('hidden');
        resultBox.innerHTML = '';
        billSuggestions = [];
        billSelectedIndex = -1;
        return;
    }

    fetch(`/bill-search-suggestions?query=${encodeURIComponent(query)}`)
        .then(res => res.json())
        .then(data => {
            billSuggestions = data;
            billSelectedIndex = -1;

            if (data.length === 0) {
                resultBox.classList.add('hidden');
                resultBox.innerHTML = '';
                return;
            }

            resultBox.innerHTML = data.map((item, index) => `
                <div 
                    class="px-3 py-2 suggestion-item hover:bg-blue-100 cursor-pointer"
                    data-index="${index}"
                    onclick="selectBillSuggestion('${item.replace(/'/g, "\\'")}')"
                >${item}</div>
            `).join('');
            resultBox.classList.remove('hidden');
        });
}

function selectBillSuggestion(value) {
    const input = document.getElementById('liveBillSearchInput');
    input.value = value;
    const resultBox = document.getElementById('billLiveResultContainer');
    resultBox.classList.add('hidden');
    resultBox.innerHTML = '';
    input.focus();
}

function updateBillActiveItem(items) {
    items.forEach((item, index) => {
        if (index === billSelectedIndex) {
            item.classList.add('bg-blue-100');
            item.scrollIntoView({ block: 'nearest' });
        } else {
            item.classList.remove('bg-blue-100');
        }
    });
}

document.addEventListener('DOMContentLoaded', function () {
    const input = document.getElementById('liveBillSearchInput');

    if (input) {
        input.addEventListener('input', function (e) {
            handleBillLiveSearch(e.target.value);
        });

        input.addEventListener('keydown', function (e) {
            const resultBox = document.getElementById('billLiveResultContainer');
            const items = resultBox.querySelectorAll('[data-index]');
            if (resultBox.classList.contains('hidden') || items.length === 0) return;

            if (e.key === 'ArrowDown') {
                e.preventDefault();
                billSelectedIndex = (billSelectedIndex + 1) % items.length;
                updateBillActiveItem(items);
            } else if (e.key === 'ArrowUp') {
                e.preventDefault();
                billSelectedIndex = (billSelectedIndex - 1 + items.length) % items.length;
                updateBillActiveItem(items);
            } else if (e.key === 'Enter' && billSelectedIndex >= 0) {
                e.preventDefault();
                const selected = billSuggestions[billSelectedIndex];
                selectBillSuggestion(selected);
            }
        });
    }
});

// Hide suggestions if clicked outside
document.addEventListener('click', function (e) {
    const input = document.getElementById('liveBillSearchInput');
    const resultBox = document.getElementById('billLiveResultContainer');
    if (!input.contains(e.target) && !resultBox.contains(e.target)) {
        resultBox.classList.add('hidden');
    }
});

</script>
<style>
body.using-keyboard #billLiveResultContainer .suggestion-item:hover {
    background-color: inherit !important;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/bill/bill-details.blade.php ENDPATH**/ ?>