

<?php $__env->startSection('content'); ?>
<div class="flex justify-center mt-10">
    <div class="w-full max-w-2xl bg-white rounded-lg shadow-lg p-8">
        <h2 class="text-3xl font-bold text-gray-800 mb-6 text-center">Create New Demand</h2>

        <?php if(session('success')): ?>
            <div class="mb-4 p-4 bg-green-100 text-green-800 rounded">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="mb-4 p-4 bg-red-100 text-red-800 rounded">
                <ul class="list-disc list-inside">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('demand.create')); ?>" class="space-y-6">
            <?php echo csrf_field(); ?>

            
            <div>
                <label for="company_id" class="block text-sm font-medium text-gray-700">Select Company</label>
                <select name="company_id" id="company_id" required
                        class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2">
                    <option value="">-- Choose Company --</option>
                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($company->id); ?>"><?php echo e($company->company_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            
            <div>
                <label for="supplier_id" class="block text-sm font-medium text-gray-700">Select Supplier</label>
                <select name="supplier_id" id="supplier_id" required
                        class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2">
                    <option value="">-- Choose Supplier --</option>
                    <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->supplier_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            
            <div>
                <label for="product_name" class="block text-sm font-medium text-gray-700">Product Name</label>
                <input type="text" name="product_name" id="product_name" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
            </div>

            
            <div>
                <label for="quantity" class="block text-sm font-medium text-gray-700">Quantity</label>
                <input type="number" name="quantity" id="quantity" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
            </div>

            
            <div>
                <label for="reminder" class="block text-sm font-medium text-gray-700">Reminder (Date & Time)</label>
                <input type="datetime-local" name="reminder" id="reminder" required
                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm px-4 py-2" />
            </div>

            <div class="text-center">
                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition duration-200">
                    Submit Demand
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\demand\create.blade.php ENDPATH**/ ?>