<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto p-6 bg-white shadow rounded print:shadow-none print:bg-transparent print:p-0">
    
    <div id="receipt">
        <!-- Header Section -->
        <div id="storeHeader" class="text-center mb-6">
            <?php if($printSetting->logo_path): ?>
                <img id="headerLogo" src="<?php echo e(asset('storage/' . $printSetting->logo_path)); ?>" alt="Store Logo" class="mx-auto mb-4" style="max-width: 150px; height: auto;">
            <?php endif; ?>
            <h1 id="headerTitle" class="text-3xl font-bold"><?php echo e($printSetting->title); ?></h1>
            <p id="headerAddress" class="text-lg text-gray-800 font-bold"><?php echo e($printSetting->address); ?></p>
            <p id="headerPhone" class="text-lg text-gray-800 font-bold">Phone: <?php echo e($printSetting->phone); ?></p>
        </div>

        <!-- All Products Table -->
        <div class="mb-6">
            <h2 class="text-xl font-semibold mb-2 text-center">All Products</h2>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm text-left border">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="border px-4 py-2">#</th>
                            <th class="border px-4 py-2">Product Name</th>
                            <th class="border px-4 py-2">Categories</th>
                            <th class="border px-4 py-2">Expiry Date</th>
                            <th class="border px-4 py-2">Quantity</th>
                            <th class="border px-4 py-2 price-col">Prices</th>
                        </tr>
                    </thead>
                    <tbody class="font-bold">
                        <?php $grandTotal = 0; ?>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="border px-4 py-2"><?php echo e($index + 1); ?></td>
                                <td class="border px-4 py-2"><?php echo e($product->name); ?></td>
                                <td class="border px-4 py-2">
                                    <?php $__currentLoopData = $product->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="inline-block bg-gray-200 rounded px-2 py-1 mr-1 text-xs">
                                            <?php echo e($category); ?>

                                        </span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td class="border px-4 py-2"><?php echo e($product->expiry_date); ?></td>
                                <td class="border px-4 py-2"><?php echo e($product->quantity); ?></td>
                                <td class="border px-4 py-2 price-col">
                                    <div><strong>Purchase:</strong> <?php echo e($product->purchase_price); ?></div>
                                    <div><strong>Retail:</strong> <?php echo e($product->retail_price); ?></div>
                                    <div><strong>Local:</strong> <?php echo e($product->local_price); ?></div>
                                    <div><strong>Doctor:</strong> <?php echo e($product->doctor_price); ?></div>
                                </td>
                            </tr>
                            <?php
                                $grandTotal += $product->retail_price ?? 0;
                            ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div id="totalPrice" class="mt-4 text-right font-bold text-lg price-col">
                    Total Retail Price: Rs. <?php echo e($grandTotal); ?>

                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="mt-4 text-base text-gray-800">
            <p><strong>Note:</strong> <?php echo e($printSetting->footer_note); ?></p>
        </div>

        <!-- Goodbye Message -->
        <div class="mt-6 text-center font-semibold text-lg">
            <p><?php echo e($printSetting->goodbye_message); ?></p>
        </div>

        <!-- Software Credit -->
        <div class="mt-10 pt-4 border-t text-center text-sm text-gray-600 print:text-black">
            <p class="mb-1">Software developed by <span class="font-semibold text-gray-800">Next Steps Sols Pvt. Ltd.</span></p>
            <p class="mb-1">🌐 <a href="https://www.nextstepsols.com" class="text-blue-600 hover:underline" target="_blank">www.nextstepsols.com</a></p>
            <p>📞 Cell: 0332-0679987</p>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="mt-6 flex justify-center space-x-4 print:hidden">
        <button onclick="togglePrice(true)" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
            Print With Price
        </button>
        <button onclick="togglePrice(false)" class="bg-gray-700 hover:bg-gray-800 text-white px-4 py-2 rounded">
            Print Without Price
        </button>
    </div>
</div>

<!-- JS: Toggle Price Columns -->
<script>
    function togglePrice(show) {
        const priceCols = document.querySelectorAll('.price-col');
        const totalPrice = document.getElementById('totalPrice');

        priceCols.forEach(col => {
            col.classList.toggle('hidden-price', !show);
        });

        if (totalPrice) {
            totalPrice.style.display = show ? 'block' : 'none';
        }

        window.print();

        // Restore price columns after printing
        if (!show) {
            setTimeout(() => {
                priceCols.forEach(col => col.classList.remove('hidden-price'));
                if (totalPrice) totalPrice.style.display = 'block';
            }, 500);
        }
    }
</script>

<!-- CSS for hiding and print layout -->
<style>
    .hidden-price {
        display: none !important;
    }

    @media print {
        .print\:hidden {
            display: none !important;
        }

        .hidden-price {
            display: none !important;
        }

        body {
            width: 100% !important;
            margin: 0 auto !important;
            padding: 0 !important;
        }

        body * {
            visibility: hidden;
        }

        #receipt, #receipt * {
            visibility: visible;
        }

        #receipt {
            width: 100% !important;
            margin: 0 auto !important;
            padding: 2mm !important;
            font-size: 12px !important;
        }

        @page {
            size: auto;
            margin: 0;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/product/print.blade.php ENDPATH**/ ?>