<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>POS | Veterinary Store</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-white h-screen flex flex-col">

    <!-- Navbar -->
    <nav class="flex items-center justify-between px-6 py-4 bg-black bg-opacity-50 shadow-md h-16">
    <!-- Left: Title -->
    <div class="flex-1 text-white text-2xl font-bold">
        Faisal Veterinary Store
    </div>

    <!-- Center: Logo -->
    <div class="flex justify-center">
        <img src="<?php echo e(asset('images/logo.png')); ?>" alt="Logo" class="h-10 w-auto rounded-full">
    </div>

    <!-- Right: Links -->
    <div class="flex-1 flex justify-end space-x-4">
        <a href="<?php echo e(route('login.index')); ?>" class="text-white font-medium hover:text-yellow-300 transition">
            Login
        </a>
        <a href="<?php echo e(route('register.index')); ?>" class="text-white font-medium hover:text-yellow-300 transition">
            Register
        </a>
    </div>
</nav>



    <!-- Hero Section -->
    <div class="flex-1 relative">
        <!-- Background Image -->
        <div class="absolute inset-0 bg-cover bg-center" style="background-image: url('<?php echo e(asset('images/logo.png')); ?>');"></div>
        
        <!-- Content (transparent section) -->
        <div class="relative z-10 flex items-center justify-center h-full px-4">
            <div class="bg-black bg-opacity-80 backdrop-blur-sm p-8 rounded-xl shadow-lg max-w-2xl w-full text-center">
                <h1 class="text-white text-4xl md:text-5xl font-extrabold leading-tight mb-6">
                    Welcome to the Faisal Veterinary Store
                </h1>
                <a href="<?php echo e(route('dashboard')); ?>" class="inline-block mt-4 px-6 py-3 bg-yellow-400 text-black text-lg font-semibold rounded-lg shadow hover:bg-yellow-500 transition">
                    Access Admin Panel
                </a>
            </div>
        </div>
    </div>

</body>
</html>
<?php /**PATH F:\Veterinary POS\POS\resources\views\welcome.blade.php ENDPATH**/ ?>