<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto p-6 bg-white shadow rounded-lg">
    <h1 class="text-2xl font-bold mb-6">Receipt Print Preview</h1>
    
    <!-- Preview Container -->
    <div class="border-2 border-gray-300 p-6 mb-6 rounded-lg">
        <!-- Header with centered title and side images -->
        <div class="flex items-center justify-between mb-8 border-b pb-4">
            <?php if(isset($receiptPrint) && $receiptPrint->image1): ?>
                <img src="<?php echo e(asset('storage/' . $receiptPrint->image1)); ?>" alt="Left Image" class="h-20">
            <?php else: ?>
                <div class="h-20 w-20 bg-gray-100 flex items-center justify-center text-gray-400">
                    <span>No Image</span>
                </div>
            <?php endif; ?>
            
            <div class="text-center mx-4">
                <h2 class="text-2xl font-bold">
                    <?php echo e(isset($receiptPrint) && $receiptPrint->header ? $receiptPrint->header : 'Default Receipt Header'); ?>

                </h2>
            </div>
            
            <?php if(isset($receiptPrint) && $receiptPrint->image2): ?>
                <img src="<?php echo e(asset('storage/' . $receiptPrint->image2)); ?>" alt="Right Image" class="h-20">
            <?php else: ?>
                <div class="h-20 w-20 bg-gray-100 flex items-center justify-center text-gray-400">
                    <span>No Image</span>
                </div>
            <?php endif; ?>
        </div>

        <!-- Content Container -->
        <div class="mb-8 p-4 border rounded-lg bg-gray-50">
            <h3 class="text-lg font-semibold mb-4 text-center">Receipt Details</h3>
            <!-- Receipt content would go here -->
        </div>

        <!-- Footer -->
        <div class="mt-6 p-4 border-t text-center">
            <p class="text-sm text-gray-600">
                <?php echo e(isset($receiptPrint) && $receiptPrint->footer ? $receiptPrint->footer : 'Thank you for your business!'); ?>

            </p>
        </div>
    </div>

    <div class="flex justify-end">
        <?php if(isset($receiptPrint)): ?>
            <button onclick="openEditModal()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
                Edit Receipt Template
            </button>
        <?php else: ?>
            <button onclick="openCreateModal()" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
                Create New Template
            </button>
        <?php endif; ?>
    </div>
</div>

<!-- Edit Modal (shown when receiptPrint exists) -->
<?php if(isset($receiptPrint)): ?>
<div id="editModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <!-- Background overlay -->
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>

        <!-- Modal content -->
        <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
            <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">
                    Edit Receipt Template
                </h3>
                 <form method="POST" action="<?php echo e(route('receipt-print.update', $receiptPrint->id)); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <!-- Header Settings -->
        <div class="mb-8 p-4 border rounded-lg">
            <h2 class="text-xl font-semibold mb-4">Header Settings</h2>
            
            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Heading</label>
                <input type="text" name="header" value="<?php echo e(old('header', $receiptPrint->header)); ?>" 
                       class="w-full p-2 border rounded" required>
            </div>
        </div>

        <!-- Images Settings -->
        <div class="mb-8 p-4 border rounded-lg">
            <h2 class="text-xl font-semibold mb-4">Images</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-gray-700 mb-2">Left Image</label>
                    <?php if($receiptPrint->image1): ?>
                        <img src="<?php echo e(asset('storage/' . $receiptPrint->image1)); ?>" alt="Current Image 1" class="h-20 mb-2">
                    <?php endif; ?>
                    <input type="file" name="image1" class="w-full p-2 border rounded">
                </div>
                
                <div>
                    <label class="block text-gray-700 mb-2">Background Image</label>
                    <?php if($receiptPrint->background_image): ?>
                        <img src="<?php echo e(asset('storage/' . $receiptPrint->background_image)); ?>" alt="Current Background" class="h-20 mb-2">
                    <?php endif; ?>
                    <input type="file" name="background_image" class="w-full p-2 border rounded">
                </div>
                
                <div>
                    <label class="block text-gray-700 mb-2">Right Image</label>
                    <?php if($receiptPrint->image2): ?>
                        <img src="<?php echo e(asset('storage/' . $receiptPrint->image2)); ?>" alt="Current Image 2" class="h-20 mb-2">
                    <?php endif; ?>
                    <input type="file" name="image2" class="w-full p-2 border rounded">
                </div>
            </div>
        </div>
        <!-- Add this section to your edit modal form -->
<div class="mb-8 p-4 border rounded-lg">
    <h2 class="text-xl font-semibold mb-4">Text Colors</h2>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
            <label class="block text-gray-700 mb-2">Header Text Color</label>
            <input type="color" name="header_text_color" 
                   value="<?php echo e(old('header_text_color', $receiptPrint->header_text_color ?? '#000000')); ?>" 
                   class="w-full p-1 border rounded">
        </div>
        
        <div>
            <label class="block text-gray-700 mb-2">Content Text Color</label>
            <input type="color" name="content_text_color" 
                   value="<?php echo e(old('content_text_color', $receiptPrint->content_text_color ?? '#000000')); ?>" 
                   class="w-full p-1 border rounded">
        </div>
         <div>
            <label class="block text-gray-700 mb-2">Finding Color</label>
            <input type="color" name="finding_color" 
                   value="<?php echo e(old('finding_color', $receiptPrint->finding_color ?? '#000000')); ?>" 
                   class="w-full p-1 border rounded">
        </div>
         <div>
            <label class="block text-gray-700 mb-2">Diagnosis Color</label>
            <input type="color" name="diagnosis_color" 
                   value="<?php echo e(old('diagnosis_color', $receiptPrint->diagnosis_color ?? '#000000')); ?>" 
                   class="w-full p-1 border rounded">
        </div>
    </div>
</div>

        <!-- Border Settings -->
        <div class="mb-8 p-4 border rounded-lg">
            <h2 class="text-xl font-semibold mb-4">Border Settings</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <h3 class="font-medium mb-2">Outer Border</h3>
                    <div class="mb-4">
                        <label class="block text-gray-700 mb-2">Color</label>
                        <input type="color" name="border1_color" 
                               value="<?php echo e(old('border1_color', $receiptPrint->border1_color)); ?>" 
                               class="w-full p-1 border rounded">
                    </div>
                    <div>
                        <label class="block text-gray-700 mb-2">Width (px)</label>
                        <input type="number" name="border1_width" min="0" max="10" 
                               value="<?php echo e(old('border1_width', $receiptPrint->border1_width)); ?>" 
                               class="w-full p-2 border rounded">
                    </div>
                </div>
                
                <div>
                    <h3 class="font-medium mb-2">Inner Border</h3>
                    <div class="mb-4">
                        <label class="block text-gray-700 mb-2">Color</label>
                        <input type="color" name="border2_color" 
                               value="<?php echo e(old('border2_color', $receiptPrint->border2_color)); ?>" 
                               class="w-full p-1 border rounded">
                    </div>
                    <div>
                        <label class="block text-gray-700 mb-2">Width (px)</label>
                        <input type="number" name="border2_width" min="0" max="10" 
                               value="<?php echo e(old('border2_width', $receiptPrint->border2_width)); ?>" 
                               class="w-full p-2 border rounded">
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer Settings -->
        <div class="mb-8 p-4 border rounded-lg">
            <h2 class="text-xl font-semibold mb-4">Footer Settings</h2>
            
            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Footer Text</label>
                <input type="text" name="footer" value="<?php echo e(old('footer', $receiptPrint->footer)); ?>" 
                       class="w-full p-2 border rounded" required>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700 mb-2">Background Color</label>
                    <input type="color" name="footer_background_color" 
                           value="<?php echo e(old('footer_background_color', $receiptPrint->footer_background_color)); ?>" 
                           class="w-full p-1 border rounded">
                </div>
                
                <div>
                    <label class="block text-gray-700 mb-2">Text Color</label>
                    <input type="color" name="footer_text_color" 
                           value="<?php echo e(old('footer_text_color', $receiptPrint->footer_text_color)); ?>" 
                           class="w-full p-1 border rounded">
                </div>
            </div>
        </div>

        <div class="flex justify-end">
            <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
                Save Changes
            </button>
        </div>
    </form>
            </div>
            <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                <button type="submit" form="receiptPrintForm" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-blue-600 text-base font-medium text-white hover:bg-blue-700 sm:ml-3 sm:w-auto sm:text-sm">
                    Save Changes
                </button>
                <button onclick="closeEditModal()" type="button" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                    Cancel
                </button>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Create Modal (shown when no receiptPrint exists) -->
<div id="createModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <!-- Background overlay -->
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>

        <!-- Modal content -->
        <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
            <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">
                    Create New Receipt Template
                </h3>
                <form id="receiptPrintCreateForm" method="POST" action="<?php echo e(route('receipt-print.create')); ?>" enctype="multipart/form-data" class="overflow-y-auto max-h-[70vh]">
                    <?php echo csrf_field(); ?>

                    <div class="mb-8 p-4 border rounded-lg">
                        <h2 class="text-xl font-semibold mb-4">Header Settings</h2>
                        
                        <div class="mb-4">
                            <label class="block text-gray-700 mb-2">Heading</label>
                            <input type="text" name="header" value="<?php echo e(old('header', 'Default Receipt Header')); ?>" class="w-full p-2 border rounded" required>
                        </div>
                    </div>

                    <div class="mb-8 p-4 border rounded-lg">
                        <h2 class="text-xl font-semibold mb-4">Images</h2>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-gray-700 mb-2">Left Image (Image 1)</label>
                                <input type="file" name="image1" class="w-full p-2 border rounded">
                            </div>
                            
                            <div>
                                <label class="block text-gray-700 mb-2">Right Image (Image 2)</label>
                                <input type="file" name="image2" class="w-full p-2 border rounded">
                            </div>
                        </div>
                    </div>

                    <div class="mb-8 p-4 border rounded-lg">
                        <h2 class="text-xl font-semibold mb-4">Footer Settings</h2>
                        
                        <div class="mb-4">
                            <label class="block text-gray-700 mb-2">Note</label>
                            <input type="text" name="footer" value="<?php echo e(old('footer', 'Thank you for your business!')); ?>" class="w-full p-2 border rounded" required>
                        </div>
                    </div>
                </form>
            </div>
            <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                <button type="submit" form="receiptPrintCreateForm" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-blue-600 text-base font-medium text-white hover:bg-blue-700 sm:ml-3 sm:w-auto sm:text-sm">
                    Create Template
                </button>
                <button onclick="closeCreateModal()" type="button" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                    Cancel
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    // Modal functions for edit
    function openEditModal() {
        document.getElementById('editModal').classList.remove('hidden');
        document.body.classList.add('overflow-hidden');
    }

    function closeEditModal() {
        document.getElementById('editModal').classList.add('hidden');
        document.body.classList.remove('overflow-hidden');
    }

    // Modal functions for create
    function openCreateModal() {
        document.getElementById('createModal').classList.remove('hidden');
        document.body.classList.add('overflow-hidden');
    }

    function closeCreateModal() {
        document.getElementById('createModal').classList.add('hidden');
        document.body.classList.remove('overflow-hidden');
    }

    // Close modals when clicking outside
    document.addEventListener('DOMContentLoaded', function() {
        const editModal = document.getElementById('editModal');
        const createModal = document.getElementById('createModal');
        
        if (editModal) {
            editModal.addEventListener('click', function(e) {
                if (e.target === this) {
                    closeEditModal();
                }
            });
        }
        
        if (createModal) {
            createModal.addEventListener('click', function(e) {
                if (e.target === this) {
                    closeCreateModal();
                }
            });
        }

        // Close modals with Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeEditModal();
                closeCreateModal();
            }
        });
    });
</script>

<style>
    .max-h-[70vh] {
        max-height: 70vh;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/receiptprint.blade.php ENDPATH**/ ?>