<?php $__env->startSection('content'); ?>
<div class="max-w-5xl mx-auto p-6 bg-white rounded shadow mt-10">
    <h2 class="text-2xl font-bold mb-6">Edit Product</h2>

    <form action="<?php echo e(route('product.update', $product->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <!-- Image Upload Section -->
    <div class="mb-6">
    <label class="font-semibold block mb-2">Product Image</label>
    <div class="flex items-center gap-6 flex-wrap">

        <?php if($product->image): ?>
        <div class="flex flex-col items-center">
            <span class="text-sm text-gray-600 mb-2">Current Image:</span>
            <img src="<?php echo e(asset('storage/' . $product->image)); ?>" 
                 alt="Current Product Image" 
                 class="w-32 h-32 object-cover rounded border border-gray-300">
        </div>
        <?php endif; ?>

        <div class="flex-1">
            <!-- Option Buttons -->
            <div class="flex gap-2 mb-2">
                <button type="button" onclick="document.getElementById('fileInput').click()" class="bg-blue-500 text-white px-3 py-1 rounded">
                    📁 Choose File
                </button>
                <button type="button" onclick="openCamera()" class="bg-green-500 text-white px-3 py-1 rounded">
                    📸 Capture
                </button>
            </div>

            <!-- Actual File Input -->
            <input type="file" id="fileInput" name="image" accept="image/*"
                   class="hidden" onchange="previewImage(event)">

            <!-- File input display -->
            <div class="border rounded p-2 bg-gray-50 text-sm text-gray-600">
                Upload new image (JPG, PNG, JPEG, max 2MB)
            </div>

            <!-- Camera Selection Dropdown -->
            <div id="cameraSelection" class="hidden mt-2">
                <label class="block mb-1 font-semibold">Select Camera:</label>
                <select id="cameraSelect" onchange="onCameraSelected()" class="border px-2 py-1 rounded text-sm">
                </select>
            </div>

            <!-- Camera container -->
            <div id="cameraContainer" class="mt-4 hidden">
                <video id="video" autoplay playsinline class="w-full max-w-xs rounded border"></video>
                <div class="mt-2 flex gap-2">
                    <button type="button" onclick="captureImage()" class="bg-red-500 text-white px-3 py-1 rounded">
                        📷 Take Picture
                    </button>
                    <button type="button" onclick="closeCamera()" class="bg-gray-500 text-white px-3 py-1 rounded">
                        ✖ Close Camera
                    </button>
                </div>
            </div>

            <!-- Preview -->
            <img id="imagePreview" src="#" alt="Preview"
                 class="w-32 h-32 object-cover border rounded mt-4 hidden">
        </div>
    </div>
</div>

<!-- Canvas (used to convert video to image file) -->
<canvas id="canvas" class="hidden"></canvas>
        <!-- Basic Product Info -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Product Name</label>
                <input type="text" name="name" value="<?php echo e($product->name); ?>" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Product Type</label>
                <input type="text" name="type" value="<?php echo e($product->type); ?>" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Salt</label>
                <input type="text" name="salt" value="<?php echo e($product->salt); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Product Company</label>
                <input type="text" name="company" value="<?php echo e($product->company); ?>" class="w-full border px-3 py-2 rounded">
            </div>

            <!-- Multi-select for Category -->
            <div class="md:col-span-2">
                <label class="font-semibold">Product Category</label>
                <select name="categories[]" class="w-full border px-3 py-2 rounded" multiple>
                    <?php
                        $selectedCategories = is_array($product->categories)
                            ? $product->categories
                            : explode(',', $product->categories ?? '');
                    ?>
                    <?php $__currentLoopData = ['injection','syrup','tablet','powder','drip','instrument','other']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat); ?>" <?php if(in_array($cat, $selectedCategories)): ?> selected <?php endif; ?>>
                            <?php echo e(ucfirst($cat)); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <p class="text-sm text-gray-500 mt-1">Hold Ctrl/Cmd to select multiple categories</p>
            </div>
        </div>

        <hr class="my-6">

        <!-- Batch Info -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Batch Number</label>
                <input type="text" name="batch_number" value="<?php echo e($product->batch_number); ?>" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Quantity</label>
                <input type="number" name="quantity" value="<?php echo e($product->quantity); ?>" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Expiry Date</label>
                <input type="date" name="expiry_date" value="<?php echo e($product->expiry_date); ?>" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Expiry Alert (Days Before)</label>
                <input type="number" name="expiry_alert" value="<?php echo e($product->expiry_alert); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Low Stock Alert</label>
                <input type="number" name="low_stock_alert" value="<?php echo e($product->low_stock_alert); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Purchase From</label>
                <input type="text" name="purchase_from" value="<?php echo e($product->purchase_from); ?>" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <hr class="my-6">

        <!-- Pricing -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Retail Price (Full Packet)</label>
                <input type="number" step="0.01" name="retail_price" value="<?php echo e($product->retail_price); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Purchase Price</label>
                <input type="number" step="0.01" name="purchase_price" value="<?php echo e($product->purchase_price); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Local Customer Sale Price</label>
                <input type="number" step="0.01" name="local_price" value="<?php echo e($product->local_price); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Doctor Sale Price</label>
                <input type="number" step="0.01" name="doctor_price" value="<?php echo e($product->doctor_price); ?>" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <hr class="my-6">

        <!-- Packet or Piece -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Sold As</label>
                <select name="unit_type" class="w-full border px-3 py-2 rounded">
                    <option value="packet" <?php echo e($product->unit_type == 'packet' ? 'selected' : ''); ?>>Packet</option>
                    <option value="LossPack" <?php echo e($product->unit_type == 'LossPack' ? 'selected' : ''); ?>>Piece</option>
                </select>
            </div>
            <div>
                <label class="font-semibold">Quantity in One Packet (e.g., tablets/ml)</label>
                <input type="number" name="pieces_per_packet" value="<?php echo e($product->pieces_per_packet); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Price Per Unit (e.g., per tablet/ml)</label>
                <input type="number" step="0.01" name="price_per_piece" value="<?php echo e($product->price_per_piece); ?>" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <div class="mt-6 flex justify-between items-center">
            <a href="<?php echo e(route('product.index')); ?>" class="text-blue-600 hover:text-blue-800 font-medium">
                ← Back to Products
            </a>
            <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold px-6 py-2 rounded">
                Update Product
            </button>
        </div>
    </form>
</div>

<script>
let stream;
let videoDevices = [];
let isMobileDevice = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);

async function openCamera() {
    try {
        // First get permission to access any camera
        const tempStream = await navigator.mediaDevices.getUserMedia({ video: true });
        tempStream.getTracks().forEach(track => track.stop()); // Stop immediately after getting permission
        
        // Now enumerate devices with labels
        const devices = await navigator.mediaDevices.enumerateDevices();
        videoDevices = devices.filter(device => device.kind === 'videoinput');

        if (videoDevices.length === 0) {
            alert("No camera devices found.");
            return;
        }

        // Always show the camera container
        document.getElementById('cameraContainer').classList.remove('hidden');

        // Show camera selection if mobile or multiple cameras
        if (isMobileDevice || videoDevices.length > 1) {
            showCameraSelection(videoDevices);
        } else {
            // For desktop with single camera, start directly
            startStream(videoDevices[0].deviceId);
        }
    } catch (err) {
        alert("Could not access camera: " + err.message);
    }
}

function showCameraSelection(devices) {
    const select = document.getElementById('cameraSelect');
    select.innerHTML = '';

    devices.forEach((device, index) => {
        const option = document.createElement('option');
        option.value = device.deviceId;

        // Try to determine camera type from label
        const label = (device.label || '').toLowerCase();
        if (label.includes('front')) {
            option.text = 'Front Camera';
        } else if (label.includes('back') || label.includes('rear')) {
            option.text = 'Back Camera';
        } else {
            option.text = `Camera ${index + 1}`;
        }

        select.appendChild(option);
    });

    document.getElementById('cameraSelection').classList.remove('hidden');
}

function onCameraSelected() {
    const deviceId = document.getElementById('cameraSelect').value;
    startStream(deviceId);
}

async function startStream(deviceId) {
    // Stop any existing stream
    if (stream) {
        stream.getTracks().forEach(track => track.stop());
    }

    try {
        const constraints = {
            video: {
                deviceId: { exact: deviceId },
                width: { ideal: 1280 },
                height: { ideal: 720 }
            }
        };

        stream = await navigator.mediaDevices.getUserMedia(constraints);
        const video = document.getElementById('video');
        video.srcObject = stream;
        
        // Ensure camera container is visible
        document.getElementById('cameraContainer').classList.remove('hidden');
    } catch (err) {
        alert("Could not start selected camera: " + err.message);
    }
}

function captureImage() {
    const video = document.getElementById('video');
    const canvas = document.getElementById('canvas');
    const fileInput = document.getElementById('fileInput');

    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    canvas.getContext('2d').drawImage(video, 0, 0);

    canvas.toBlob(function (blob) {
        const file = new File([blob], "captured.jpg", { type: "image/jpeg" });
        const dataTransfer = new DataTransfer();
        dataTransfer.items.add(file);

        fileInput.files = dataTransfer.files;
        previewImage({ target: fileInput });
    }, "image/jpeg", 0.9); // 0.9 is the quality (90%)

    closeCamera();
}

function closeCamera() {
    if (stream) {
        stream.getTracks().forEach(track => track.stop());
        stream = null;
    }
    
    document.getElementById('cameraContainer').classList.add('hidden');
    document.getElementById('cameraSelection').classList.add('hidden');
    
    const video = document.getElementById('video');
    video.srcObject = null;
}

function previewImage(event) {
    const input = event.target;
    const preview = document.getElementById('imagePreview');

    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function (e) {
            preview.src = e.target.result;
            preview.classList.remove('hidden');
        };
        reader.readAsDataURL(input.files[0]);
    }
}

// Clean up when the page is unloaded
window.addEventListener('beforeunload', function() {
    if (stream) {
        stream.getTracks().forEach(track => track.stop());
    }
});
</script

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/product/edit.blade.php ENDPATH**/ ?>