<?php $__env->startSection('content'); ?>
<!-- Main container (removed duplicate max-w-3xl and bg-white) -->
<div class="p-6 print:p-0">
    
    <!-- Receipt Container (removed duplicate classes) -->
    <div id="receipt1" style="border: <?php echo e($receiptPrint->border1_width); ?>px solid <?php echo e($receiptPrint->border1_color); ?>; padding: 20px; margin: 0 auto;">
        
        <!-- Inner Container with equal padding -->
        <div class="copy-page p-6 rounded shadow" style="border: <?php echo e($receiptPrint->border2_width); ?>px solid <?php echo e($receiptPrint->border2_color); ?>; margin: 10px 0;">
            
            <!-- Header Section -->
            <div class="flex items-center justify-between mb-6">
                <?php if($receiptPrint->image1): ?>
                    <img src="<?php echo e(asset('storage/' . $receiptPrint->image1)); ?>" alt="Left Logo" class="w-20 h-20 object-contain">
                <?php endif; ?>

                <div class="text-center" style="color: <?php echo e($receiptPrint->header_text_color); ?>;">
                    <h1 class="text-3xl font-bold"><?php echo e($receiptPrint->header); ?></h1>
                </div>

                <?php if($receiptPrint->image2): ?>
                    <img src="<?php echo e(asset('storage/' . $receiptPrint->image2)); ?>" alt="Right Logo" class="w-20 h-20 object-contain">
                <?php endif; ?>
            </div>

            <div class="receipt-content relative">
                <!-- Background Image -->
                <div class="absolute inset-0 overflow-hidden rounded-full flex items-center justify-center opacity-20 z-0">
                    <?php if($receiptPrint->background_image): ?>
                        <img src="<?php echo e(asset('storage/' . $receiptPrint->background_image)); ?>" 
                             alt="Background Logo" 
                             class="min-w-full min-h-full object-cover rounded-full" 
                             style="transform: scale(1.2);">
                    <?php endif; ?>
                </div>

                <!-- Content Section -->
                <div style="color: <?php echo e($receiptPrint->content_text_color); ?>;">
                    <!-- Date & Time -->
                    <div class="flex justify-between mb-2 text-lg">
                        <span class="font-bold">Date:</span>
                        <span><?php echo e($receipt->date); ?></span>
                        <span class="font-semibold">Time:</span>
                        <span><?php echo e($receipt->time); ?></span>
                    </div>

                    <!-- Receipt Info -->
                    <div class="border-t border-b py-4 mb-4 text-lg">
                          <div class="flex justify-between mb-3">
                <span class="font-bold">Animal Tag No:</span>
                <span class="font-bold"><?php echo e($receipt->animal_tag_no); ?></span>
            </div>
            <div class="flex justify-between mb-2">
                <span class="font-bold">Patient No:</span>
                <span class="font-bold"><?php echo e($receipt->id); ?></span>
            </div>
            <div class="flex justify-between mb-2">
                <span class="font-semibold">Farmer Name:</span>
                <span class="font-bold"><?php echo e($receipt->farmer_name ?? 'N/A'); ?></span>
            </div>
            <div class="flex justify-between mb-2">
                <span class="font-bold">Ref By:</span>
                <span class="font-bold"><?php echo e($receipt->referred_by); ?></span>
            </div>
            <div class="flex justify-between mb-2">
                <span class="font-bold">Animal:</span>
                <span class="font-bold"><?php echo e($receipt->animal); ?></span>
            </div>
            <div class="flex justify-between mb-2">
                <span class="font-bold">Temperature:</span>
                <span class="font-bold"><?php echo e($receipt->temperature); ?> F</span>
            </div>
            <div class="flex justify-between mb-2">
                <span class="font-bold">Sample:</span>
                <span class="font-bold"><?php echo e($receipt->sample); ?></span>
            </div>
            <div class="flex justify-between mb-2">
    <span class="font-bold">Pregnancy:</span>
    <span class="font-bold">
        <?php echo e($receipt->pregnancy); ?>

        <?php if(strtolower($receipt->pregnancy) === 'yes' && !empty($receipt->pregnancy_month)): ?>
            (<?php echo e($receipt->pregnancy_month); ?> month<?php echo e($receipt->pregnancy_month > 1 ? 's' : ''); ?>)
        <?php endif; ?>
    </span>
</div>
            <div class="flex justify-between mb-2">
                <span class="font-bold">Deworming:</span>
                <span class="font-bold"><?php echo e($receipt->deworming); ?></span>
            </div>
            <div class="flex justify-between mb-2" style="color: <?php echo e($receiptPrint->finding_color); ?>;">
                <span class="font-bold">Finding:</span>
                <span class="font-bold"><?php echo e($receipt->finding ?? 'N/A'); ?></span>
            </div>
             <div class="flex justify-between mb-2" style="color: <?php echo e($receiptPrint->diagnosis_color); ?>;">
                <span class="font-bold">Suspected Diagnosis:</span>
                <span class="font-bold"><?php echo e($receipt->diagnosis ?? 'N/A'); ?></span>
            </div>
                    </div>
                </div>
            </div>

            <!-- Receipt Image -->
            <?php if(!empty($receipt->image)): ?>
                <div class="flex justify-center my-4">  <!-- Equal margin top and bottom -->
                    <img src="<?php echo e(asset('storage/' . $receipt->image)); ?>" alt="Receipt Image" 
                         class="w-32 h-auto rounded shadow-md border border-gray-300">
                </div>
            <?php endif; ?>

            <!-- Footer -->
            <div class="text-center font-bold text-lg p-4 mt-2 rounded footer-area"
                 style="background-color: <?php echo e($receiptPrint->footer_background_color); ?>;
                        color: <?php echo e($receiptPrint->footer_text_color); ?>;">
                <p><?php echo e($receiptPrint->footer); ?></p>
            </div>
             <span class="text-center justify-center flex font-bold">(Note: Not Valid For Any Court of Law)</span>
        </div>
    </div>

    <!-- Print Button (outside receipt container) -->
    <div class="mt-6 flex justify-center space-x-4 print:hidden">
        <button onclick="handlePrint()" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
            Print
        </button>
    </div>
</div>

<!-- Print Styling -->
<style>
    /* Removed duplicate container styles */
    #receipt1 {
        max-width: 42rem;
        margin-left: auto;
        margin-right: auto;
    }
    
    .receipt-content {
        position: relative;
        padding: 2rem;
        background-color: rgba(255, 255, 255, 0.8);
        border-radius: 0.5rem;
    }
    
    @media print {
        body {
           margin: 0;
        padding: 0;
        width: 210mm !important; /* A4 width */
        font-family: Arial, Helvetica, sans-serif !important; /* Default system font */
        font-size: 14px !important;
        }
          @page {
        size: A4;
        margin: 10mm;
    }
        
        /* Hide everything except the receipt */
        body * {
            visibility: hidden;
        }
        
        #receipt1, #receipt1 * {
            visibility: visible;
        }
        
        /* Reset positioning for print */
        #receipt1 {
          
            padding: 20px !important;
            border: <?php echo e($receiptPrint->border1_width); ?>px solid <?php echo e($receiptPrint->border1_color); ?> !important;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        
        .copy-page {
            border: <?php echo e($receiptPrint->border2_width); ?>px solid <?php echo e($receiptPrint->border2_color); ?> !important;
            padding: 20px !important;
            margin: 10px 0 !important;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        
        /* Ensure colors print correctly */
        .footer-area, .header-text, .text-content {
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        
        /* Hide print button in print view */
        .print-hidden, .print\:hidden {
            display: none !important;
        }
        
      
    }
</style>

<script>
    function handlePrint() {
        window.print();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/receipt/completeprint.blade.php ENDPATH**/ ?>