

<?php $__env->startSection('content'); ?>
<div class="max-w-5xl mx-auto p-6 bg-white rounded shadow mt-10">
    <h2 class="text-2xl font-bold mb-6">Add New Product</h2>

    <form action="<?php echo e(route('product.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <!-- Basic Product Info -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Product Name</label>
                <input type="text" name="name" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Product Type</label>
                <input type="text" name="type" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Salt</label>
                <input type="text" name="salt" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Product Company</label>
                <input type="text" name="company" class="w-full border px-3 py-2 rounded">
            </div>

            <!-- Multi-select for Category -->
            <div class="md:col-span-2">
                <label class="font-semibold">Product Category</label>
                <select name="categories[]" class="w-full border px-3 py-2 rounded" multiple>
                    <option value="injection">Injection</option>
                    <option value="syrup">Syrup</option>
                    <option value="tablet">Tablet</option>
                    <option value="powder">Powder</option>
                    <option value="drip">Drip</option>
                    <option value="instrument">Instrument</option>
                    <option value="other">Other</option>
                </select>
                <p class="text-sm text-gray-500 mt-1">Hold Ctrl to select multiple.</p>
            </div>
        </div>

        <hr class="my-6">

        <!-- Batch Info -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Batch Number</label>
                <input type="text" name="batch_number" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Quantity</label>
                <input type="number" name="quantity" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Expiry Date</label>
                <input type="date" name="expiry_date" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Expiry Alert (Days Before)</label>
                <input type="number" name="expiry_alert" class="w-full border px-3 py-2 rounded" value="30">
            </div>
            <div>
                <label class="font-semibold">Low Stock Alert</label>
                <input type="number" name="low_stock_alert" class="w-full border px-3 py-2 rounded" value="10">
            </div>
            <div>
                <label class="font-semibold">Purchase From</label>
                <input type="text" name="purchase_from" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <hr class="my-6">

        <!-- Pricing -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Retail Price (Full Packet)</label>
                <input type="number" step="0.01" name="retail_price" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Purchase Price</label>
                <input type="number" step="0.01" name="purchase_price" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Local Customer Sale Price</label>
                <input type="number" step="0.01" name="local_price" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Doctor Sale Price</label>
                <input type="number" step="0.01" name="doctor_price" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <hr class="my-6">

        <!-- Packet or Piece -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Sold As</label>
                <select name="unit_type" class="w-full border px-3 py-2 rounded">
                    <option value="packet">Packet</option>
                    <option value="piece">Piece</option>
                </select>
            </div>
            <div>
                <label class="font-semibold">Pieces Per Packet (if any)</label>
                <input type="number" name="pieces_per_packet" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Price Per Piece (for loss pack)</label>
                <input type="number" step="0.01" name="price_per_piece" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <!-- Image Upload -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-6">
            <div>
                <label class="font-semibold">Product Image</label>
                <input type="file" name="image" accept="image/*" class="w-full border px-3 py-2 rounded" onchange="previewImage(event)">
            </div>
            <div>
                <label class="font-semibold">Preview</label>
                <img id="imagePreview" src="#" alt="Image Preview" class="w-32 h-32 object-cover border rounded mt-2 hidden">
            </div>
        </div>

        <div class="mt-6">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold px-6 py-2 rounded">
                Add Product
            </button>
        </div>
    </form>
</div>

<script>
    function previewImage(event) {
        const reader = new FileReader();
        const preview = document.getElementById('imagePreview');

        reader.onload = function () {
            preview.src = reader.result;
            preview.classList.remove('hidden');
        }

        if (event.target.files[0]) {
            reader.readAsDataURL(event.target.files[0]);
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\product\create.blade.php ENDPATH**/ ?>