

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8">
    <h1 class="text-2xl font-bold text-gray-800 mb-6">Animal Receipt Form</h1>
    
    <form action="<?php echo e(route('receipt.store')); ?>" method="POST" enctype="multipart/form-data" class="bg-white shadow-md rounded px-8 pt-6 pb-8 mb-4">
        <?php echo csrf_field(); ?>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Patient Information -->
           
            


            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="animal_tag_no">
                    Animal Tag Number
                </label>
                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                       id="animal_tag_no" name="animal_tag_no" type="text" placeholder="Enter tag number" required>
            </div>

            <!-- Animal Dropdown -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="animal">
                    Animal
                </label>
                <select class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                        id="animal" name="animal" required>
                    <option value="">Select Animal</option>
                    <option value="cow">Cow</option>
                    <option value="dog">Dog</option>
                    <option value="horse">Horse</option>
                   <option value="buffalo">Buffalo</option>
                   
                    <option value="goat">Goat</option>
                    <option value="cat">Cat</option>
                </select>
            </div>

            <!-- Gender Dropdown -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="gender">
                    Gender
                </label>
                <select class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                        id="gender" name="gender" required>
                    <option value="">Select Gender</option>
                    <option value="male">Male</option>
                    <option value="female">Female</option>
                </select>
            </div>

            <!-- Farmer Information -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="farmer_name">
                    Farmer Name
                </label>
                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                       id="farmer_name" name="farmer_name" type="text" placeholder="Enter farmer name" required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="contact_no">
                    Contact Number
                </label>
                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                       id="contact_no" name="contact_no" type="tel" placeholder="Enter contact number" required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="referred_by">
                    Referred By
                </label>
                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                       id="referred_by" name="referred_by" type="text" placeholder="Enter referral name" required>
            </div>

            <!-- Animal Details -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="age">
                    Age
                </label>
                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                       id="age" name="age" type="text" placeholder="Enter age" required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="temperature">
                    Temperature (°F)
                </label>
                <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                       id="temperature" name="temperature" type="number" step="0.1" placeholder="Enter temperature" required>
            </div>

            <!-- Sample Dropdown -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="sample">
                    Sample
                </label>
                <select class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                        id="sample" name="sample">
                    <option value="">Select Sample</option>
                    <option value="blood_examine">Blood Examine</option>
                    <option value="fecal_examine">Fecal Examine</option>
                    <option value="semen_examine">Semen Examine</option>
                </select>
            </div>

            <!-- Pregnancy Section -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="pregnancy">
                    Pregnancy
                </label>
                <div class="flex items-center space-x-4">
                    <label class="inline-flex items-center">
                        <input type="radio" class="form-radio" name="pregnancy" value="yes" id="pregnancy_yes">
                        <span class="ml-2">Yes</span>
                    </label>
                    <label class="inline-flex items-center">
                        <input type="radio" class="form-radio" name="pregnancy" value="no" id="pregnancy_no" checked>
                        <span class="ml-2">No</span>
                    </label>
                </div>
                
                <div id="pregnancy_month_container" class="mt-2 hidden">
                    <label class="block text-gray-700 text-sm font-bold mb-2" for="pregnancy_month">
                        Pregnancy Month
                    </label>
                    <input class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" 
                           id="pregnancy_month" name="pregnancy_month" type="number" min="1" max="12" placeholder="Enter month (1-12)">
                </div>
            </div>

            <!-- Deworming Section -->
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="deworming">
                    Deworming
                </label>
                <div class="flex items-center space-x-4">
                    <label class="inline-flex items-center">
                        <input type="radio" class="form-radio" name="deworming" value="yes">
                        <span class="ml-2">Yes</span>
                    </label>
                    <label class="inline-flex items-center">
                        <input type="radio" class="form-radio" name="deworming" value="no" checked>
                        <span class="ml-2">No</span>
                    </label>
                </div>
            </div>

           
        </div>

        <!-- Submit Button -->
        
<div class="flex items-center justify-start mt-6">
    <button class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-6 rounded-lg focus:outline-none focus:shadow-outline transition duration-200" 
            type="submit">
        Submit Receipt
    </button>
</div>
        
    </form>
</div>

<script>
    // Show/hide pregnancy month field based on selection
    document.addEventListener('DOMContentLoaded', function() {
        const pregnancyYes = document.getElementById('pregnancy_yes');
        const pregnancyNo = document.getElementById('pregnancy_no');
        const pregnancyMonthContainer = document.getElementById('pregnancy_month_container');
        
        function togglePregnancyMonth() {
            if (pregnancyYes.checked) {
                pregnancyMonthContainer.classList.remove('hidden');
            } else {
                pregnancyMonthContainer.classList.add('hidden');
            }
        }
        
        pregnancyYes.addEventListener('change', togglePregnancyMonth);
        pregnancyNo.addEventListener('change', togglePregnancyMonth);
        
        // Initialize on page load
        togglePregnancyMonth();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/receipt/form.blade.php ENDPATH**/ ?>