

<?php $__env->startSection('content'); ?>
<div class="p-4">
    <h2 class="text-2xl font-bold mb-6">All Bill Details</h2>

    <div class="w-full overflow-auto">
        <table class="min-w-[1000px] table-auto border text-sm text-left whitespace-nowrap">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-4 py-2">Bill No</th>
                    <th class="px-4 py-2">Customer Name</th>
                    <th class="px-4 py-2">Product Name</th>
                    <th class="px-4 py-2">Product Price</th>
                    <th class="px-4 py-2">Retail Price</th>
                    <th class="px-4 py-2">Less from Retail</th>
                    <th class="px-4 py-2">Quantity</th>
                    <th class="px-4 py-2">Product Total Price</th>
                    <th class="px-4 py-2">payment_Type</th>
                    <th class="px-4 py-2">Grand Total</th>
                    <th class="px-4 py-2">Date</th>
                    <th class="px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $bills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-b">
                        <td class="px-4 py-2"><?php echo e($bill->id); ?></td>
                        <td class="px-4 py-2"><?php echo e($bill->customer_name); ?></td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->product->name ?? 'N/A'); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->price_type ?? 'N/A'); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->retail_price); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->less_from_retail); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->qty); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2">
                            <?php $__currentLoopData = $bill->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->amount); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="px-4 py-2"><?php echo e($bill->payment ?? 'N/A'); ?></td>
                        <td class="px-4 py-2 font-bold"><?php echo e($bill->total_amount); ?></td>
                        <td class="px-4 py-2"><?php echo e($bill->date); ?></td>
                        <td class="px-4 py-2 space-x-2">
                            <a href="#" class="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600">Edit</a>
                            <a href="<?php echo e(route('print.view', $bill->id)); ?>" class="bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600">Print</a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\bill\bill-details.blade.php ENDPATH**/ ?>