<?php $__env->startSection('content'); ?>
<div class="mx-auto p-6 shadow rounded print:shadow-none print:bg-transparent print:p-0">
    
    <div id="receipt" style="border: <?php echo e($receiptPrint->border1_width); ?>px solid <?php echo e($receiptPrint->border1_color); ?>; padding: 20px; margin: 0 auto; max-width: 42rem;">

        <!-- Loop for Department & Patient Copy -->
        <?php $__currentLoopData = ['Department Copy', 'Patient Copy']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $copyType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <!-- Inner Border Container for each copy -->
            <div class="copy-page p-6 bg-white rounded shadow relative <?php echo e($index === 1 ? 'pt-20' : 'mb-6'); ?>"
                 style="border: <?php echo e($receiptPrint->border2_width); ?>px solid <?php echo e($receiptPrint->border2_color); ?>;">

                <?php if($index === 1): ?>
                    <!-- Separation Line -->
                    <div class="absolute top-0 left-0 w-full flex items-center justify-center print:block">
                        <div class="w-full border-t-2 border-dashed border-gray-500"></div>
                        <div class="absolute -top-3 left-1/2 transform -translate-x-1/2 bg-white px-2 text-sm font-semibold text-gray-500">
                            Tear Here
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Header Section with Images -->
                <div class="receipt-header flex items-center justify-between mb-6" style="color: <?php echo e($receiptPrint->header_text_color); ?>;">
                    <?php if($receiptPrint->image1): ?>
                        <img src="<?php echo e(asset('storage/' . $receiptPrint->image1)); ?>" alt="Image 1" class="header-image-1 w-20 h-20 object-contain">
                    <?php else: ?>
                        <div class="w-20 h-20"></div>
                    <?php endif; ?>

                    <div class="text-center">
                        <h1 class="header-title text-3xl font-bold"><?php echo e($receiptPrint->header); ?></h1>
                        <p class="copy-type mt-1 text-lg font-bold"><?php echo e($copyType); ?></p>
                    </div>

                    <?php if($receiptPrint->image2): ?>
                        <img src="<?php echo e(asset('storage/' . $receiptPrint->image2)); ?>" alt="Image 2" class="header-image-2 w-20 h-20 rounded-full object-cover">
                    <?php else: ?>
                        <div class="w-20 h-20"></div>
                    <?php endif; ?>
                </div>

                <div class="receipt-content relative">
                    <!-- Background Image Container -->
                    <div class="absolute inset-0 overflow-hidden rounded-full flex items-center justify-center opacity-20 z-0">
                        <?php if($receiptPrint->background_image): ?>
                            <img src="<?php echo e(asset('storage/' . $receiptPrint->background_image)); ?>" 
                                 alt="Background Logo" 
                                 class="min-w-full min-h-full object-cover rounded-full" 
                                 style="transform: scale(1.2);">
                        <?php endif; ?>
                    </div>

                    <!-- Content Container -->
                    <div class="relative z-10" style="color: <?php echo e($receiptPrint->content_text_color); ?>;">
                        <!-- Date & Time -->
                        <div class="flex justify-between mb-2 text-lg">
                            <span class="font-bold">Date:</span>
                            <span class="font-bold"><?php echo e($receipt->date); ?></span>
                            <span class="font-semibold">Time:</span>
                            <span class="font-bold"><?php echo e($receipt->time); ?></span>
                        </div>

                        <!-- Receipt Info -->
                        <div class="border-t border-b py-4 mb-4 text-lg">
                            <div class="flex justify-between mb-3">
                                <span class="font-bold">Animal Tag No:</span>
                                <span class="font-bold"><?php echo e($receipt->animal_tag_no); ?></span>
                            </div>
                            <div class="flex justify-between mb-2">
                                <span class="font-bold">Patient No:</span>
                                <span class="font-bold"><?php echo e($receipt->id); ?></span>
                            </div>
                            <div class="flex justify-between mb-2">
                                <span class="font-semibold">Farmer Name:</span>
                                <span class="font-bold"><?php echo e($receipt->farmer_name ?? 'N/A'); ?></span>
                            </div>
                            <div class="flex justify-between mb-2">
                                <span class="font-bold">Ref By:</span>
                                <span class="font-bold"><?php echo e($receipt->referred_by); ?></span>
                            </div>
                            <div class="flex justify-between mb-2">
                                <span class="font-bold">Animal:</span>
                                <span class="font-bold"><?php echo e($receipt->animal); ?></span>
                            </div>
                            <div class="flex justify-between mb-2">
                                <span class="font-bold">Temperature:</span>
                                <span class="font-bold"><?php echo e($receipt->temperature); ?>°F</span>
                            </div>
                            <div class="flex justify-between mb-2">
                                <span class="font-bold">Sample:</span>
                                <span class="font-bold"><?php echo e($receipt->sample); ?></span>
                            </div>
                           <div class="flex justify-between mb-2">
    <span class="font-bold">Pregnancy:</span>
    <span class="font-bold">
        <?php echo e($receipt->pregnancy); ?>

        <?php if(strtolower($receipt->pregnancy) === 'yes' && !empty($receipt->pregnancy_month)): ?>
            (<?php echo e($receipt->pregnancy_month); ?> month<?php echo e($receipt->pregnancy_month > 1 ? 's' : ''); ?>)
        <?php endif; ?>
    </span>
</div>

                            <div class="flex justify-between mb-2">
                                <span class="font-bold">Deworming:</span>
                                <span class="font-bold"><?php echo e($receipt->deworming); ?></span>
                            </div>
                            <div class="flex justify-between mb-2">
                                <span class="font-bold">Finding:</span>
                                <span class="font-bold"><?php echo e($receipt->finding ?? 'N/A'); ?></span>
                            </div>

                            <?php if(!empty($receipt->image)): ?>
                                <div class="flex justify-center mt-8">
                                    <img src="<?php echo e(asset('storage/' . $receipt->image)); ?>" alt="Receipt Image" 
                                         class="max-w-md w-full h-auto rounded shadow-md border border-gray-300">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Footer -->
                <div class="text-center font-bold text-lg p-4 mt-6 rounded goodbye-message"
                     style="background-color: <?php echo e($receiptPrint->footer_background_color); ?>;
                            color: <?php echo e($receiptPrint->footer_text_color); ?>;">
                    <p><?php echo e($receiptPrint->footer); ?></p>
                </div>
                 <span class="text-center justify-center flex font-bold">(Note: Not Valid For Any Court of Law)</span>
                <!-- Software Credit -->
                <div class="software-credit mt-10 pt-4 border-t text-center text-sm text-gray-600 print:text-black">
                    <p class="mb-1 font-bold">Software developed by <span class="font-bold text-gray-800">Next Steps Solutions Pvt. Ltd.</span></p>
                    <p class="mb-1 font-bold">🌐 <a href="https://www.nextstepsols.com" class="hover:underline" target="_blank">www.nextstepsols.com</a></p>
                    <p class='font-bold'>📞 Cell: 0332-0679987</p>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Buttons -->
    <div class="mt-6 flex justify-center space-x-4 print:hidden">
        <button onclick="setreceiptMode(true)" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded">
            Detailed Print
        </button>
        <button onclick="setreceiptMode(false)" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded">
            Simple Print
        </button>
        <button onclick="handlePrint()" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
            Print
        </button>
    </div>
</div>

<!-- Print Styling -->
<style>
    #receipt {
        max-width: 42rem;
        margin-left: auto;
        margin-right: auto;
    }
    
    .receipt-content {
        position: relative;
        padding: 2rem;
        background-color: rgba(255, 255, 255, 0.8);
        border-radius: 0.5rem;
    }
    
   @media print {
    body {
        margin: 0;
        padding: 0;
    }

    body * {
        visibility: hidden;
    }

    #receipt, #receipt * {
        visibility: visible;
    }

    #receipt {
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
        padding: 20px !important;
        border: <?php echo e($receiptPrint->border1_width); ?>px solid <?php echo e($receiptPrint->border1_color); ?> !important;
        width: 100%;
        height: auto;
        margin: 0 auto !important;
    }

}

        
        .copy-page {
            border: <?php echo e($receiptPrint->border2_width); ?>px solid <?php echo e($receiptPrint->border2_color); ?> !important;
            padding: 20px !important;
            background: white !important;
            margin-bottom: 10px !important;
        }
        
        .receipt-content {
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
            background-color: rgba(255, 255, 255, 0.9) !important;
        }
        
        .receipt-content .absolute {
            display: flex !important;
            opacity: 0.15 !important;
        }
        
        .goodbye-message {
            background-color: <?php echo e($receiptPrint->footer_background_color); ?> !important;
            color: <?php echo e($receiptPrint->footer_text_color); ?> !important;
        }
        
        
        .avoid-break {
            page-break-inside: avoid;
        }
    }
</style>

<!-- Print Script -->
<script>
    function setreceiptMode(detailed) {
        const headers = document.querySelectorAll('.receipt-header');
        const image1s = document.querySelectorAll('.header-image-1');
        const image2s = document.querySelectorAll('.header-image-2');
        const titles = document.querySelectorAll('.header-title');
        const copyTypes = document.querySelectorAll('.copy-type');
        const goodbyes = document.querySelectorAll('.goodbye-message');
        const softwares = document.querySelectorAll('.software-credit');

        for (let i = 0; i < headers.length; i++) {
            if (detailed) {
                headers[i].style.display = 'flex';
                image1s[i].style.display = 'block';
                image2s[i].style.display = 'block';
                titles[i].style.display = 'block';
                copyTypes[i].style.display = 'block';
                goodbyes[i].style.display = 'block';
                softwares[i].style.display = 'block';
            } else {
                headers[i].style.display = 'flex';
                image1s[i].style.display = 'none';
                image2s[i].style.display = 'none';
                titles[i].style.display = 'none';
                copyTypes[i].style.display = 'block';
                headers[i].style.justifyContent = 'center';
                goodbyes[i].style.display = 'block';
                softwares[i].style.display = 'block';
            }
        }
    }

    // function handlePrint() {
    //     window.print();
    // }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/receipt/print.blade.php ENDPATH**/ ?>