<?php $__env->startSection('content'); ?>
<div class="p-4">
    <h2 class="text-3xl font-bold text-gray-800 mb-6">All Notes Details</h2>

    <!-- No Results Message -->
    <?php if(request('search') && $notes->isEmpty()): ?>
        <div class="text-red-500 mb-4">No results found for "<?php echo e(request('search')); ?>".</div>
    <?php endif; ?>

    <!-- Table -->
    <div class="w-full overflow-x-auto">
        <table class="min-w-[1000px] table-auto border text-sm text-left whitespace-nowrap shadow-lg rounded-lg overflow-hidden">
            <thead class="bg-gray-200 text-gray-700">
                <tr>
                    <th class="px-4 py-2">ID</th>
                    <th class="px-4 py-2">Note Title</th>
                    <th class="px-4 py-2">Note</th>
                    <th class="px-4 py-2">Date</th>
                    <th class="px-4 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b hover:bg-gray-50">
                        <td class="px-4 py-2"><?php echo e($note->id); ?></td>
                        <td class="px-4 py-2"><?php echo e($note->title); ?></td>
                        <td class="px-4 py-2"><?php echo e($note->note); ?></td>
                        <td class="px-4 py-2"><?php echo e($note->created_at); ?></td>
                        <td class="px-4 py-2 space-x-2">
                            <button
                                onclick="openModal(this)"
                                class="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600"
                                data-id="<?php echo e($note->id); ?>"
                                data-title="<?php echo e($note->title); ?>"
                                data-note="<?php echo e($note->note); ?>"
                            >
                                Edit
                            </button>

                            <form action="<?php echo e(route('note.delete', $note->id)); ?>" method="POST" class="inline-block">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600" onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                            <button
                                onclick="printNote('<?php echo e($note->title); ?>', '<?php echo e($note->note); ?>', '<?php echo e($note->created_at->format('Y-m-d')); ?>')"
                                class="bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600"
                            >
                                Print
                            </button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-gray-500 py-4">No records found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-40">
        <div class="bg-white rounded-lg p-6 w-full max-w-md shadow-xl relative">
            <button onclick="closeModal()"
                    class="absolute top-2 right-2 text-gray-500 hover:text-gray-700 text-2xl font-bold">
                &times;
            </button>
            <h3 class="text-xl font-semibold mb-4 text-gray-800">Update Company</h3>

            <form id="editForm" method="POST" action="">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Title</label>
                    <input type="text" name="title" value="" required
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
                </div>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700">Note</label>
                    <input type="text" name="note" value="" required
                           class="mt-1 block w-full border border-gray-300 rounded-md px-4 py-2 shadow-sm" />
                </div>

                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700 transition duration-200">
                    Update
                </button>
            </form>
        </div>
    </div>

</div>

<!-- JavaScript -->
<script>
    function openModal(button) {
        const modal = document.getElementById('editModal');
        const form = document.getElementById('editForm');

        // Set form action dynamically
        const noteId = button.getAttribute('data-id');
        form.action = `/note/update/${noteId}`;

        // Set input values
        form.querySelector('[name="title"]').value = button.getAttribute('data-title');
        form.querySelector('[name="note"]').value = button.getAttribute('data-note');
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    function closeModal() {
        const modal = document.getElementById('editModal');
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }

    function printNote(title, note, date) {
        // Ensure the note and title are properly encoded to handle special characters
        title = title.replace(/'/g, "\\'").replace(/"/g, '\\"');
        note = note.replace(/'/g, "\\'").replace(/"/g, '\\"');

        if (!title && !note) {
            alert('Please enter something to print.');
            return;
        }

        const popup = window.open('', '_blank', 'width=400,height=600');
        popup.document.write(`
            <html>
            <head>
                <title>Note Print</title>
                <style>
                    body { font-family: 'Noto Nastaliq Urdu', 'Arial', sans-serif; direction: rtl; padding: 10px; font-size: 30px; }
                    h2 { font-size: 35px; margin-bottom: 10px; }
                </style>
            </head>
            <body onload="window.print(); window.close();">
                <h2>Title: ${title}</h2>
                <p> <strong>Note</strong> :${note.replace(/\n/g, '<br>')}</p>
                <p><strong>Date:</strong> ${date}</p>
            </body>
            </html>
        `);
        popup.document.close();
    }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/demand/noteShow.blade.php ENDPATH**/ ?>