<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <!-- Customer Information Header -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden mb-6">
        <div class="bg-theme px-4 py-3">
            <div class="flex justify-between items-center">
                <h2 class="text-xl font-bold text-white">Customer Credit History - <?php echo e($customer->name); ?></h2>
                <a href="<?php echo e(url()->previous()); ?>" class="bg-white hover:bg-gray-100 text-theme font-bold py-1 px-3 rounded text-sm">
                    &larr; Back
                </a>
            </div>
            <div class="mt-2 grid grid-cols-2 md:grid-cols-4 gap-2 text-white text-sm">
                <div>
                    <span class="font-semibold">Phone:</span> <?php echo e($customer->phone ?? 'N/A'); ?>

                </div>
                <div>
                    <span class="font-semibold">Total Paid:</span>
                    <span class="text-green-200"><?php echo e(number_format($paid, 2)); ?></span>
                </div>
                <div>
                    <span class="font-semibold">Total Due:</span>
                    <span class="text-red-200"><?php echo e(number_format($due, 2)); ?></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Transaction History -->
    <div class="mb-6">
        <h3 class="text-lg font-semibold text-theme mb-3">Transaction History</h3>

        <?php if($records->flatten()->isEmpty()): ?>
            <div class="bg-white p-6 rounded-lg shadow-md text-center">
                <p class="text-gray-600">No transactions found for this customer.</p>
            </div>
        <?php else: ?>
            <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mb-8 bg-white rounded-lg shadow-md overflow-hidden">
                <div class="bg-gray-100 px-4 py-2 border-b border-gray-200">
                    <h4 class="font-semibold text-theme">
                        <?php echo e(\Carbon\Carbon::parse($date)->setTimezone('Asia/Karachi')->format('F j, Y (l)')); ?>

                    </h4>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Time</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Details</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Paid Amount</th>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Due Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3 text-sm text-gray-500">
            <?php echo e(\Carbon\Carbon::parse($item['data']->time)->format('h:i A')); ?> <!-- Already timezone adjusted -->
        </td>
                                <td class="px-4 py-3">
                                    <?php if($item['type'] === 'bill'): ?>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                                            Bill
                                        </span>
                                    <?php else: ?>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                            Payment
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3">
                                    <?php if($item['type'] === 'bill'): ?>
                                        <div class="font-medium text-theme">Bill #<?php echo e($item['data']->id); ?></div>
                                        <div class="text-xs text-gray-500">
                                            <?php $__currentLoopData = $item['data']->billItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $billItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                • <?php echo e($billItem->product->name); ?> 
                                                (<?php echo e($billItem->qty); ?> × <?php echo e(number_format($billItem->price, 2)); ?>)<br>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php else: ?>
                                        <div class="font-medium text-theme">Payment</div>
                                        <div class="text-xs text-gray-500 leading-5">
                                            <div><strong>Time:</strong> <?php echo e(\Carbon\Carbon::parse($item['data']->time)->format('h:i A')); ?></div>
                                            <?php if(!empty($item['data']->notes)): ?>
                                                <div><strong>Note:</strong> <?php echo e($item['data']->notes); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-sm font-semibold text-green-600">
                                    <?php if($item['type'] === 'bill'): ?>
                                        <?php echo e(number_format(0, 2)); ?>

                                    <?php else: ?>
                                        <?php echo e(number_format($item['data']->paid_amount, 2)); ?>

                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-sm font-semibold text-red-600">
                                    <?php if($item['type'] === 'bill'): ?>
                                        <?php echo e(number_format($item['amount'], 2)); ?>

                                    <?php else: ?>
                                        <?php echo e(number_format($item['data']->due_amount, 2)); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </div>
</div>

<style>
    .bg-theme {
        background-color: #1d3244;
    }
    .text-theme {
        color: #1d3244;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/bill/credit/customerCredit.blade.php ENDPATH**/ ?>