

<?php $__env->startSection('content'); ?>
<div class="max-w-5xl mx-auto p-6 bg-white rounded shadow mt-10">
    <h2 class="text-2xl font-bold mb-6">Edit Product</h2>

    <form action="<?php echo e(route('product.update', $product->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <!-- Basic Product Info -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Product Name</label>
                <input type="text" name="name" value="<?php echo e($product->name); ?>" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Product Type</label>
                <input type="text" name="type" value="<?php echo e($product->type); ?>" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Salt</label>
                <input type="text" name="salt" value="<?php echo e($product->salt); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Product Company</label>
                <input type="text" name="company" value="<?php echo e($product->company); ?>" class="w-full border px-3 py-2 rounded">
            </div>

            <!-- Multi-select for Category (assume comma-separated string) -->
            <div class="md:col-span-2">
                <label class="font-semibold">Product Category</label>
                <select name="categories[]" class="w-full border px-3 py-2 rounded" multiple>
                <?php
    $selectedCategories = is_array($product->categories)
        ? $product->categories
        : explode(',', $product->categories ?? '');
?>

<?php $__currentLoopData = ['injection','syrup','tablet','powder','drip','instrument','other']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <option value="<?php echo e($cat); ?>" <?php if(in_array($cat, $selectedCategories)): ?> selected <?php endif; ?>>
        <?php echo e(ucfirst($cat)); ?>

    </option>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </select>
            </div>
        </div>

        <hr class="my-6">

        <!-- Batch Info -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Batch Number</label>
                <input type="text" name="batch_number" value="<?php echo e($product->batch_number); ?>" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Quantity</label>
                <input type="number" name="quantity" value="<?php echo e($product->quantity); ?>" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Expiry Date</label>
                <input type="date" name="expiry_date" value="<?php echo e($product->expiry_date); ?>" class="w-full border px-3 py-2 rounded" required>
            </div>
            <div>
                <label class="font-semibold">Expiry Alert (Days Before)</label>
                <input type="number" name="expiry_alert" value="<?php echo e($product->expiry_alert); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Low Stock Alert</label>
                <input type="number" name="low_stock_alert" value="<?php echo e($product->low_stock_alert); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Purchase From</label>
                <input type="text" name="purchase_from" value="<?php echo e($product->purchase_from); ?>" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <hr class="my-6">

        <!-- Pricing -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Retail Price (Full Packet)</label>
                <input type="number" step="0.01" name="retail_price" value="<?php echo e($product->retail_price); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Purchase Price</label>
                <input type="number" step="0.01" name="purchase_price" value="<?php echo e($product->purchase_price); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Local Customer Sale Price</label>
                <input type="number" step="0.01" name="local_price" value="<?php echo e($product->local_price); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Doctor Sale Price</label>
                <input type="number" step="0.01" name="doctor_price" value="<?php echo e($product->doctor_price); ?>" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <hr class="my-6">

        <!-- Packet or Piece -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="font-semibold">Sold As</label>
                <select name="unit_type" class="w-full border px-3 py-2 rounded">
                    <option value="packet" <?php echo e($product->unit_type == 'packet' ? 'selected' : ''); ?>>Packet</option>
                    <option value="piece" <?php echo e($product->unit_type == 'piece' ? 'selected' : ''); ?>>Piece</option>
                </select>
            </div>
            <div>
                <label class="font-semibold">Pieces Per Packet (if any)</label>
                <input type="number" name="pieces_per_packet" value="<?php echo e($product->pieces_per_packet); ?>" class="w-full border px-3 py-2 rounded">
            </div>
            <div>
                <label class="font-semibold">Price Per Piece (for loss pack)</label>
                <input type="number" step="0.01" name="price_per_piece" value="<?php echo e($product->price_per_piece); ?>" class="w-full border px-3 py-2 rounded">
            </div>
        </div>

        <div class="mt-6">
            <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold px-6 py-2 rounded">
                Update Product
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Veterinary POS\POS\resources\views\product\edit.blade.php ENDPATH**/ ?>