<?php $__env->startSection('content'); ?>
<div class="p-4">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-800">Ledger Details #<?php echo e($ledger->id); ?></h2>
        <a href="<?php echo e(route('ledger.show')); ?>" class="text-blue-600 hover:text-blue-800">Back to Ledgers</a>
    </div>

    <!-- Ledger Summary -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
            <div>
                <h3 class="text-lg font-semibold text-gray-700">Company</h3>
                <p class="text-gray-900"><?php echo e($ledger->company?->company_name ?? 'N/A'); ?></p>
            </div>
            <div>
                <h3 class="text-lg font-semibold text-gray-700">Supplier</h3>
                <p class="text-gray-900"><?php echo e($ledger->supplier?->supplier_name ?? 'N/A'); ?></p>
            </div>
            <div>
                <h3 class="text-lg font-semibold text-gray-700">Date</h3>
               <p class="text-gray-900">
     <?php echo e(\Carbon\Carbon::now()->format('d M Y')); ?>

</p> </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div class="bg-blue-50 p-4 rounded-lg">
                <h3 class="text-lg font-semibold text-blue-800">Total Bill</h3>
                <p class="text-2xl font-bold text-blue-900"><?php echo e(number_format($ledger->total_bill, 2)); ?></p>
            </div>
            <div class="bg-green-50 p-4 rounded-lg">
                <h3 class="text-lg font-semibold text-green-800">Paid Amount</h3>
                <p class="text-2xl font-bold text-green-900"><?php echo e(number_format($ledger->paid_amount, 2)); ?></p>
            </div>
            <div class="bg-red-50 p-4 rounded-lg">
                <h3 class="text-lg font-semibold text-red-800">Due Amount</h3>
                <p class="text-2xl font-bold text-red-900"><?php echo e(number_format($ledger->due_amount, 2)); ?></p>
            </div>
        </div>
    </div>


  <!-- Ledger Items -->
<div class="bg-white rounded-lg shadow">
    <h3 class="bg-gray-50 px-6 py-3 text-lg font-medium text-gray-900">Items</h3>

    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Product</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Amount</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Paid</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Due Payment</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ledger Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Payment Date</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $ledger->ledgerItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                        <?php echo e($item->stock); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php echo e(number_format((float)($item->total_amount ?? 0), 2)); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php echo e(number_format((float)($item->paid_amount ?? 0), 2)); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php echo e(number_format((float)($item->due_amount ?? 0), 2)); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php echo e($item->ledger_date); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php echo e($item->payment_date); ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-sm text-gray-500">No items found for this ledger.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

    <!-- Manual Adjustments -->
<div class="bg-white rounded-lg shadow mt-6">
    <h3 class="bg-gray-50 px-6 py-3 text-lg font-medium text-gray-900">Manual Adjustments</h3>

    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Time</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Paid Amount</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Due Amount</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $adjustments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $adjustment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php echo e(\Carbon\Carbon::parse($adjustment->date)->format('d M Y')); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php echo e(\Carbon\Carbon::parse($adjustment->time)->format('h:i A')); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-green-600 font-medium">
                        <?php echo e(number_format($adjustment->paid_amount, 2)); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-red-600 font-medium">
                        <?php echo e(number_format($adjustment->due_amount, 2)); ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="4" class="px-6 py-4 text-center text-sm text-gray-500">
                        No manual adjustments found for this ledger.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
    <!-- Payment History -->
    
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/multnorq/faisalveterinary.store/resources/views/supplier/ledger/details.blade.php ENDPATH**/ ?>